/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageHelper;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.helpers.MachineSource;
import appeng.util.SettingsFrom;
import com.almostreliable.merequester.Config;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.StorageManager;
import com.almostreliable.merequester.requester.abstraction.RequestHost;
import com.almostreliable.merequester.requester.status.LinkState;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.almostreliable.merequester.requester.status.StatusState;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RequesterBlockEntity
extends AENetworkBlockEntity
implements RequestHost,
IGridTickable,
ICraftingRequester {
    private static final String REQUESTS_ID = "requests";
    private static final String REQUEST_STATUS_ID = "request_status";
    private static final String STORAGE_MANAGER_ID = "storage_manager";
    private final Requests requests;
    private final StatusState[] requestStatus;
    private final StorageManager storageManager;
    private final IActionSource actionSource;
    private TickRateModulation currentTickRate = TickRateModulation.IDLE;

    public RequesterBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.requests = new Requests(this);
        this.requestStatus = new StatusState[((Integer)Config.COMMON.requests.get()).intValue()];
        Arrays.fill(this.requestStatus, StatusState.IDLE);
        this.storageManager = new StorageManager(this);
        this.actionSource = new MachineSource((IActionHost)this);
        this.getMainNode().setExposedOnSides(this.getExposedSides()).addService(IGridTickable.class, (IGridNodeService)this).addService(ICraftingRequester.class, (IGridNodeService)this).addService(IStorageWatcherNode.class, (IGridNodeService)this.storageManager).setIdlePowerUsage(((Double)Config.COMMON.idleEnergy.get()).doubleValue());
        if (((Boolean)Config.COMMON.requireChannel.get()).booleanValue()) {
            this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        }
    }

    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        if (tag.contains(REQUESTS_ID)) {
            this.requests.deserializeNBT(tag.getCompound(REQUESTS_ID));
        }
        if (tag.contains(REQUEST_STATUS_ID)) {
            this.deserializeStatus(tag.getCompound(REQUEST_STATUS_ID));
        }
        if (tag.contains(STORAGE_MANAGER_ID)) {
            this.storageManager.deserializeNBT(tag.getCompound(STORAGE_MANAGER_ID));
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put(REQUESTS_ID, (Tag)this.requests.serializeNBT());
        tag.put(REQUEST_STATUS_ID, (Tag)this.serializeStatus());
        tag.put(STORAGE_MANAGER_ID, (Tag)this.storageManager.serializeNBT());
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD && input.contains(REQUESTS_ID)) {
            this.requests.deserializeNBT(input.getCompound(REQUESTS_ID));
        }
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.put(REQUESTS_ID, (Tag)this.requests.serializeNBT());
        }
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(this.getExposedSides());
        super.onReady();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.level == null || this.level.isClientSide || !this.getMainNode().isActive()) {
            return TickRateModulation.IDLE;
        }
        if (this.handleRequests()) {
            this.setChanged();
        }
        return this.currentTickRate;
    }

    @Override
    public void requestChanged(int index) {
        this.storageManager.clear(index);
        this.saveChanges();
    }

    @Override
    public Requests getRequests() {
        return this.requests;
    }

    @Override
    public Component getTerminalName() {
        return this.hasCustomName() ? Objects.requireNonNull(this.getCustomName()) : Utils.translate("block", "requester", new Object[0]);
    }

    public void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.getMainNode().setExposedOnSides(this.getExposedSides());
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return this.getExposedSides();
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        this.storageManager.addDrops(drops);
    }

    private void deserializeStatus(CompoundTag tag) {
        for (int i = 0; i < this.requestStatus.length; ++i) {
            if (!tag.contains(String.valueOf(i))) continue;
            CompoundTag stateTag = tag.getCompound(String.valueOf(i));
            ICraftingLink link = StorageHelper.loadCraftingLink((CompoundTag)stateTag, (ICraftingRequester)this);
            this.requestStatus[i] = new LinkState(link);
        }
    }

    private CompoundTag serializeStatus() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.requestStatus.length; ++i) {
            StatusState state = this.requestStatus[i];
            if (!(state instanceof LinkState)) continue;
            LinkState cls = (LinkState)state;
            CompoundTag stateTag = new CompoundTag();
            cls.link().writeToNBT(stateTag);
            tag.put(String.valueOf(i), (Tag)stateTag);
        }
        return tag;
    }

    private boolean handleRequests() {
        boolean changed = false;
        TickRateModulation tickRateModulation = TickRateModulation.IDLE;
        for (int i = 0; i < this.requestStatus.length; ++i) {
            TickRateModulation resultTickRateModulation;
            StatusState state = this.requestStatus[i];
            StatusState result = this.handleRequest(i);
            if (!Objects.equals(state, result)) {
                changed = true;
            }
            if ((resultTickRateModulation = result.getTickRateModulation()).ordinal() > tickRateModulation.ordinal()) {
                tickRateModulation = resultTickRateModulation;
            }
            this.updateRequestStatus(i, result);
        }
        this.currentTickRate = tickRateModulation;
        return changed;
    }

    private StatusState handleRequest(int slot) {
        StatusState state = this.requestStatus[slot];
        this.updateRequestStatus(slot, state.handle(this, slot));
        if (this.requestStatus[slot].type() != RequestStatus.IDLE && !Objects.equals(this.requestStatus[slot], state)) {
            return this.handleRequest(slot);
        }
        return this.requestStatus[slot];
    }

    private void updateRequestStatus(int slot, StatusState state) {
        this.requestStatus[slot] = state;
        if (state.type().translateToClient() != this.requests.get(slot).getClientStatus()) {
            this.requests.get(slot).setClientStatus(state.type().translateToClient());
            this.markForUpdate();
        }
    }

    private EnumSet<Direction> getExposedSides() {
        EnumSet<Direction> exposedSides = EnumSet.allOf(Direction.class);
        exposedSides.remove(this.getFront());
        return exposedSides;
    }

    boolean isActive() {
        return Arrays.stream(this.requestStatus).anyMatch(p -> p.type().translateToClient() != RequestStatus.IDLE);
    }

    public IGrid getMainNodeGrid() {
        IGrid grid = this.getMainNode().getGrid();
        Objects.requireNonNull(grid, "RequesterBlockEntity was not fully initialized - Grid is null");
        return grid;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public IActionSource getActionSource() {
        return this.actionSource;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return (ImmutableSet)Arrays.stream(this.requestStatus).filter(LinkState.class::isInstance).map(state -> ((LinkState)state).link()).collect(ImmutableSet.toImmutableSet());
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable mode) {
        for (int i = 0; i < this.requestStatus.length; ++i) {
            LinkState cls;
            StatusState state = this.requestStatus[i];
            if (!(state instanceof LinkState) || !(cls = (LinkState)state).link().equals(link)) continue;
            if (mode != Actionable.SIMULATE) {
                this.storageManager.get(i).update(what, amount);
            }
            return amount;
        }
        throw new IllegalStateException("No CraftingLinkState found");
    }

    public void jobStateChange(ICraftingLink link) {
    }

    public long getSortValue() {
        return (long)this.worldPosition.getZ() << 24 ^ (long)this.worldPosition.getX() << 8 ^ (long)this.worldPosition.getY();
    }
}

