/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester.abstraction;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import com.almostreliable.merequester.MERequester;
import com.almostreliable.merequester.network.RequesterSyncPacket;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.abstraction.RequestTracker;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractRequesterMenu
extends AEBaseMenu {
    public static final String SORT_BY_ID = "sort_by";
    public static final String UNIQUE_NAME_ID = "unique_name";
    private long idSerial = Long.MIN_VALUE;

    protected AbstractRequesterMenu(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
        this.createPlayerInventorySlots(playerInventory);
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        RequestTracker requestTracker = this.getRequestTracker(id);
        if (requestTracker == null) {
            return;
        }
        if (slot < 0 || slot >= requestTracker.getServer().size()) {
            MERequester.LOGGER.warn("Requester Screen refers to invalid slot {} of {}", (Object)slot, (Object)requestTracker.getName());
            return;
        }
        InternalInventory requestSlot = requestTracker.getServer().getSlotInv(slot);
        ItemStack requestStack = requestSlot.getStackInSlot(0);
        ItemStack carriedStack = this.getCarried();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                requestSlot.setItemDirect(0, carriedStack.isEmpty() ? ItemStack.EMPTY : carriedStack.copy());
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (carriedStack.isEmpty()) {
                    requestSlot.setItemDirect(0, ItemStack.EMPTY);
                    break;
                }
                ItemStack copy = carriedStack.copy();
                copy.setCount(1);
                requestSlot.setItemDirect(0, copy);
                break;
            }
            case SHIFT_CLICK: {
                requestSlot.setItemDirect(0, ItemStack.EMPTY);
                break;
            }
            case EMPTY_ITEM: {
                EmptyingAction emptyingAction = ContainerItemStrategies.getEmptyingAction((ItemStack)carriedStack);
                if (emptyingAction == null) break;
                requestSlot.insertItem(0, GenericStack.wrapInItemStack((AEKey)emptyingAction.what(), (long)emptyingAction.maxAmount()), false);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.getAbilities().instabuild || !carriedStack.isEmpty()) break;
                if (requestStack.isEmpty()) {
                    this.setCarried(ItemStack.EMPTY);
                    break;
                }
                ItemStack stack = requestStack.copy();
                stack.setCount(stack.getMaxStackSize());
                this.setCarried(stack);
                break;
            }
        }
    }

    public void applyDragAndDrop(ServerPlayer player, int requestIndex, long requesterId, ItemStack item) {
        this.setCarried(item);
        this.doAction(player, InventoryAction.PICKUP_OR_SET_DOWN, requestIndex, requesterId);
        this.setCarried(ItemStack.EMPTY);
    }

    public void updateRequesterState(long requesterId, int requestIndex, boolean state) {
        RequestTracker requestTracker = this.getRequestTracker(requesterId);
        if (requestTracker == null) {
            return;
        }
        Requests.Request request = requestTracker.getServer().get(requestIndex);
        request.updateState(state);
    }

    public void updateRequesterNumbers(long requesterId, int requestIndex, long amount, long batch) {
        RequestTracker requestTracker = this.getRequestTracker(requesterId);
        if (requestTracker == null) {
            return;
        }
        Requests.Request request = requestTracker.getServer().get(requestIndex);
        request.updateAmount(amount);
        request.updateBatch(batch);
    }

    protected abstract void sendFullUpdate(@Nullable IGrid var1);

    protected abstract void sendPartialUpdate();

    protected void syncRequestTrackerFull(RequestTracker requestTracker) {
        Requests server = requestTracker.getServer();
        Requests client = requestTracker.getClient();
        CompoundTag tag = server.serializeNBT();
        client.deserializeNBT(tag);
        tag.putString(UNIQUE_NAME_ID, requestTracker.getName());
        tag.putLong(SORT_BY_ID, requestTracker.getSortBy());
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{RequesterSyncPacket.inventory(requestTracker.getId(), tag)});
        }
    }

    protected void syncRequestTrackerPartial(RequestTracker requestTracker) {
        Player player;
        Requests server = requestTracker.getServer();
        Requests client = requestTracker.getClient();
        CompoundTag tag = null;
        for (int i = 0; i < server.size(); ++i) {
            Requests.Request clientRequest;
            Requests.Request serverRequest = server.get(i);
            if (!serverRequest.isDifferent(clientRequest = client.get(i))) continue;
            if (tag == null) {
                tag = new CompoundTag();
                tag.putString(UNIQUE_NAME_ID, requestTracker.getName());
                tag.putLong(SORT_BY_ID, requestTracker.getSortBy());
            }
            CompoundTag serverData = serverRequest.serializeNBT();
            tag.put(String.valueOf(i), (Tag)serverData);
            clientRequest.deserializeNBT(serverData);
        }
        if (tag != null && (player = this.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{RequesterSyncPacket.inventory(requestTracker.getId(), tag)});
        }
    }

    protected RequestTracker createTracker(RequesterBlockEntity requester) {
        RequestTracker requestTracker = new RequestTracker(requester, this.idSerial);
        ++this.idSerial;
        return requestTracker;
    }

    @Nullable
    protected abstract RequestTracker getRequestTracker(long var1);
}

