/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.chunk;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class SafeBlockGetter
implements BlockGetter {
    private final ServerLevel wrapped;
    private final Thread mainThread;

    public SafeBlockGetter(ServerLevel wrapped) {
        this.wrapped = wrapped;
        this.mainThread = Thread.currentThread();
    }

    public boolean shouldUse() {
        return Thread.currentThread() != this.mainThread;
    }

    @Nullable
    private BlockGetter getChunkSafe(BlockPos pos) {
        LightChunk access = this.wrapped.getChunkSource().getChunkForLighting(pos.getX() >> 4, pos.getZ() >> 4);
        if (!(access instanceof ChunkAccess)) {
            return null;
        }
        ChunkAccess chunk = (ChunkAccess)access;
        if (!chunk.getStatus().isOrAfter(ChunkStatus.FULL)) {
            return null;
        }
        return chunk;
    }

    public int getMaxBuildHeight() {
        return this.wrapped.getMaxBuildHeight();
    }

    public int getMaxLightLevel() {
        return this.wrapped.getMaxLightLevel();
    }

    public int getMinBuildHeight() {
        return this.wrapped.getMinBuildHeight();
    }

    public int getHeight() {
        return this.wrapped.getHeight();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockGetter g = this.getChunkSafe(pos);
        return g == null ? null : g.getBlockEntity(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        BlockGetter g = this.getChunkSafe(pos);
        return g == null ? Blocks.AIR.defaultBlockState() : g.getBlockState(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        BlockGetter g = this.getChunkSafe(pos);
        return g == null ? Fluids.EMPTY.defaultFluidState() : g.getFluidState(pos);
    }
}

