/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.structure.CachingStructureManager;

public class ModernFixCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"modernfix").then(((LiteralArgumentBuilder)Commands.literal((String)"upgradeStructures").requires(source -> source.hasPermission(3))).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            if (level == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Couldn't find server level"));
                return 0;
            }
            CloseableResourceManager manager = level.getServer().resources.resourceManager();
            Map structures = manager.listResources("structures", p -> p.getPath().endsWith(".nbt"));
            int upgradedNum = 0;
            Pattern pathPattern = Pattern.compile("^structures/(.*)\\.nbt$");
            for (Map.Entry entry : structures.entrySet()) {
                ++upgradedNum;
                ResourceLocation found = (ResourceLocation)entry.getKey();
                Matcher matcher = pathPattern.matcher(found.getPath());
                if (!matcher.matches()) continue;
                ResourceLocation structureLocation = new ResourceLocation(found.getNamespace(), matcher.group(1));
                try {
                    InputStream resource = ((Resource)entry.getValue()).open();
                    try {
                        CachingStructureManager.readStructureTag(structureLocation, level.getServer().getFixerUpper(), resource);
                        MutableComponent msg = Component.literal((String)("checked " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")"));
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ModernFixCommands.lambda$register$2((Component)msg), false);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Throwable e) {
                    ModernFix.LOGGER.error("Couldn't upgrade structure " + found, e);
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("error reading " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")")));
                }
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"All structures upgraded"), false);
            return 1;
        })));
    }

    private static /* synthetic */ Component lambda$register$2(Component msg) {
        return msg;
    }
}

