/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.blast_search_trees;

import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.world.item.ItemStack;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.searchtree.RecipeBookSearchTree;
import org.embeddedt.modernfix.searchtree.SearchTreeProviderRegistry;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
@ClientOnlyMixin
public abstract class MinecraftMixin {
    @Shadow
    @Final
    private SearchRegistry searchRegistry;

    @Shadow
    public abstract <T> void populateSearchTree(SearchRegistry.Key<T> var1, List<T> var2);

    @Inject(method={"createSearchTrees()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceSearchTrees(CallbackInfo ci) {
        SearchTreeProviderRegistry.Provider provider = SearchTreeProviderRegistry.getSearchTreeProvider();
        if (provider == null) {
            return;
        }
        ModernFix.LOGGER.info("Replacing search trees with '{}' provider", (Object)provider.getName());
        SearchRegistry.TreeBuilderSupplier nameSupplier = list -> provider.getSearchTree(false);
        SearchRegistry.TreeBuilderSupplier tagSupplier = list -> provider.getSearchTree(true);
        this.searchRegistry.register(SearchRegistry.CREATIVE_NAMES, nameSupplier);
        this.searchRegistry.register(SearchRegistry.CREATIVE_TAGS, tagSupplier);
        this.searchRegistry.register(SearchRegistry.RECIPE_COLLECTIONS, list -> new RecipeBookSearchTree((SearchTree<ItemStack>)provider.getSearchTree(false), (List<RecipeCollection>)list));
        ModernFixPlatformHooks.INSTANCE.registerCreativeSearchTrees(this.searchRegistry, (SearchRegistry.TreeBuilderSupplier<ItemStack>)nameSupplier, (SearchRegistry.TreeBuilderSupplier<ItemStack>)tagSupplier, this::populateSearchTree);
        GLFWErrorCallback oldCb = GLFW.glfwSetErrorCallback(null);
        for (KeyMapping mapping : KeyMapping.ALL.values()) {
            mapping.getTranslatedKeyMessage();
        }
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)oldCb);
        ci.cancel();
    }
}

