/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.cache_upgraded_structures;

import com.mojang.datafixers.DataFixer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.structure.CachingStructureManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={StructureTemplateManager.class})
public class StructureManagerMixin {
    @Shadow
    @Final
    private DataFixer fixerUpper;
    @Shadow
    private ResourceManager resourceManager;
    @Shadow
    @Final
    private HolderGetter<Block> blockLookup;

    @Overwrite
    private Optional<StructureTemplate> loadFromResource(ResourceLocation id) {
        Optional<StructureTemplate> optional;
        block9: {
            ResourceLocation arg = new ResourceLocation(id.getNamespace(), "structures/" + id.getPath() + ".nbt");
            InputStream stream = this.resourceManager.open(arg);
            try {
                optional = Optional.of(CachingStructureManager.readStructure(id, this.fixerUpper, stream, this.blockLookup));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
                catch (IOException e) {
                    ModernFix.LOGGER.error("Can't read structure", (Throwable)e);
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }
}

