/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_resources;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.dynamicresources.ModelLocationCache;
import org.embeddedt.modernfix.util.DynamicOverridableMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockModelShaper.class})
@ClientOnlyMixin
public class BlockModelShaperMixin {
    @Shadow
    @Final
    private ModelManager modelManager;
    @Shadow
    private Map<BlockState, BakedModel> modelByStateCache;
    private ThreadLocal<Reference2ReferenceLinkedOpenHashMap<BlockState, BakedModel>> mfix$modelCache = ThreadLocal.withInitial(Reference2ReferenceLinkedOpenHashMap::new);

    @Inject(method={"<init>(Lnet/minecraft/client/resources/model/ModelManager;)V", "replaceCache(Ljava/util/Map;)V"}, at={@At(value="RETURN")})
    private void replaceModelMap(CallbackInfo ci) {
        this.modelByStateCache = new DynamicOverridableMap<BlockState, BakedModel>(state -> this.modelManager.getModel(ModelLocationCache.get(state)));
        this.mfix$modelCache = ThreadLocal.withInitial(Reference2ReferenceLinkedOpenHashMap::new);
    }

    private BakedModel cacheBlockModel(BlockState state) {
        BakedModel model;
        ModelResourceLocation mrl = ModelLocationCache.get(state);
        BakedModel bakedModel = model = mrl == null ? null : this.modelManager.getModel(mrl);
        if (model == null) {
            model = this.modelManager.getMissingModel();
        }
        return model;
    }

    @Overwrite
    public BakedModel getBlockModel(BlockState state) {
        Reference2ReferenceLinkedOpenHashMap<BlockState, BakedModel> map = this.mfix$modelCache.get();
        BakedModel model = (BakedModel)map.get((Object)state);
        if (model != null) {
            return model;
        }
        model = this.cacheBlockModel(state);
        map.putAndMoveToFirst((Object)state, (Object)model);
        if (map.size() > 500) {
            map.removeLast();
        }
        return model;
    }
}

