/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.entry;

import com.almostreliable.lootjs.core.entry.CompositeLootEntry;
import com.almostreliable.lootjs.core.entry.DynamicLootEntry;
import com.almostreliable.lootjs.core.entry.EmptyLootEntry;
import com.almostreliable.lootjs.core.entry.ItemLootEntry;
import com.almostreliable.lootjs.core.entry.TableReferenceLootEntry;
import com.almostreliable.lootjs.core.entry.TagLootEntry;
import com.almostreliable.lootjs.loot.LootConditionList;
import com.almostreliable.lootjs.loot.LootEntryList;
import com.almostreliable.lootjs.util.DebugInfo;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootEntry {
    public static final List<LootItemCondition> EMPTY_CONDITIONS = List.of();
    public static final List<LootItemFunction> EMPTY_FUNCTIONS = List.of();

    public static ItemLootEntry of(ItemStack itemStack) {
        return new ItemLootEntry(itemStack);
    }

    public static ItemLootEntry of(Item item, NumberProvider count) {
        return new ItemLootEntry(item, count, null);
    }

    public static ItemLootEntry of(Item item, NumberProvider count, CompoundTag nbt) {
        return new ItemLootEntry(item, count, nbt);
    }

    public static EmptyLootEntry empty() {
        return new EmptyLootEntry();
    }

    public static TableReferenceLootEntry reference(ResourceLocation location) {
        return new TableReferenceLootEntry(location);
    }

    public static TagLootEntry tag(String tag) {
        return LootEntry.tag(tag, false);
    }

    public static TagLootEntry tag(String tag, boolean expand) {
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        return new TagLootEntry((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(tag)), expand);
    }

    public static CompositeLootEntry alternative(LootEntry ... entries) {
        LootEntryList el = new LootEntryList(entries);
        LootConditionList cl = new LootConditionList();
        return new CompositeLootEntry((CompositeEntryBase)new AlternativesEntry(el.getElements(), cl.getElements()), el, cl);
    }

    public static CompositeLootEntry sequence(LootEntry ... entries) {
        LootEntryList el = new LootEntryList(entries);
        LootConditionList cl = new LootConditionList();
        return new CompositeLootEntry((CompositeEntryBase)new SequentialEntry(el.getElements(), cl.getElements()), el, cl);
    }

    public static CompositeLootEntry group(LootEntry ... entries) {
        LootEntryList el = new LootEntryList(entries);
        LootConditionList cl = new LootConditionList();
        return new CompositeLootEntry((CompositeEntryBase)new EntryGroup(el.getElements(), cl.getElements()), el, cl);
    }

    public static CompositeLootEntry ofIngredient(Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            throw new IllegalArgumentException("[LootEntry.ofIngredient()] Invalid ingredient, returning empty group. Consider using `LootEntry.empty()` if you want to create an empty loot entry.");
        }
        CompositeLootEntry group = LootEntry.group(new LootEntry[0]);
        LootEntryList entries = group.getEntries();
        for (ItemStack item : ingredient.getItems()) {
            entries.add(new ItemLootEntry(item));
        }
        return group;
    }

    public static LootEntry ofVanilla(LootPoolEntryContainer vanillaEntry) {
        if (vanillaEntry instanceof LootItem) {
            LootItem e = (LootItem)vanillaEntry;
            return new ItemLootEntry(e);
        }
        if (vanillaEntry instanceof TagEntry) {
            TagEntry e = (TagEntry)vanillaEntry;
            return new TagLootEntry(e);
        }
        if (vanillaEntry instanceof EmptyLootItem) {
            EmptyLootItem e = (EmptyLootItem)vanillaEntry;
            return new EmptyLootEntry(e);
        }
        if (vanillaEntry instanceof LootTableReference) {
            LootTableReference e = (LootTableReference)vanillaEntry;
            return new TableReferenceLootEntry(e);
        }
        if (vanillaEntry instanceof DynamicLoot) {
            DynamicLoot e = (DynamicLoot)vanillaEntry;
            return new DynamicLootEntry(e);
        }
        if (vanillaEntry instanceof CompositeEntryBase) {
            CompositeEntryBase c = (CompositeEntryBase)vanillaEntry;
            return new CompositeLootEntry(c);
        }
        return new Unknown(vanillaEntry);
    }

    public LootPoolEntryType getVanillaType();

    public LootPoolEntryContainer getVanillaEntry();

    public LootEntry when(Consumer<LootConditionList> var1);

    public LootConditionList getConditions();

    default public ResourceLocation getType() {
        ResourceLocation key = BuiltInRegistries.LOOT_POOL_ENTRY_TYPE.getKey((Object)this.getVanillaType());
        if (key == null) {
            throw new IllegalStateException("Could not find key for loot pool entry type " + this.getVanillaType());
        }
        return key;
    }

    default public void collectDebugInfo(DebugInfo info) {
    }

    default public boolean isItem() {
        return this.getVanillaType() == LootPoolEntries.ITEM;
    }

    default public boolean isTag() {
        return this.getVanillaType() == LootPoolEntries.TAG;
    }

    default public boolean isEmpty() {
        return this.getVanillaType() == LootPoolEntries.EMPTY;
    }

    default public boolean isDynamic() {
        return this.getVanillaType() == LootPoolEntries.DYNAMIC;
    }

    default public boolean isReference() {
        return this.getVanillaType() == LootPoolEntries.REFERENCE;
    }

    default public boolean isSimple() {
        return !this.isComposite();
    }

    default public boolean isAlternative() {
        return this.getVanillaType() == LootPoolEntries.ALTERNATIVES;
    }

    default public boolean isSequence() {
        return this.getVanillaType() == LootPoolEntries.SEQUENCE;
    }

    default public boolean isGroup() {
        return this.getVanillaType() == LootPoolEntries.ALTERNATIVES;
    }

    default public boolean isComposite() {
        return this.isAlternative() || this.isSequence() || this.isGroup();
    }

    public record Unknown(LootPoolEntryContainer getVanillaEntry) implements LootEntry
    {
        @Override
        public LootPoolEntryType getVanillaType() {
            return this.getVanillaEntry().getType();
        }

        @Override
        public LootEntry when(Consumer<LootConditionList> callback) {
            return this;
        }

        @Override
        public LootConditionList getConditions() {
            return new LootConditionList();
        }

        @Override
        public void collectDebugInfo(DebugInfo info) {
            info.add("Unknown entry type: " + this.getType());
        }
    }
}

