/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.entry;

import com.almostreliable.lootjs.core.entry.AbstractSimpleLootEntry;
import com.almostreliable.lootjs.core.entry.SingleLootEntry;
import com.almostreliable.lootjs.util.DebugInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.Nullable;

public class TagLootEntry
extends AbstractSimpleLootEntry<TagEntry>
implements SingleLootEntry {
    public TagLootEntry(TagEntry vanillaEntry) {
        super(vanillaEntry);
    }

    public TagLootEntry(TagKey<Item> tag, boolean expand) {
        super(new TagEntry(tag, expand, 1, 0, EMPTY_CONDITIONS, EMPTY_FUNCTIONS));
    }

    public boolean getExpand() {
        return ((TagEntry)this.vanillaEntry).expand;
    }

    public void setExpand(boolean expand) {
        ((TagEntry)this.vanillaEntry).expand = expand;
    }

    public String getTag() {
        return ((TagEntry)this.vanillaEntry).tag.location().toString();
    }

    public void setTag(String tag) {
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        ((TagEntry)this.vanillaEntry).tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(tag));
    }

    public boolean isTag(String tag) {
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        return tag.equals(this.getTag());
    }

    @Override
    @Nullable
    public ItemStack create(LootContext context) {
        if (!this.getExpand()) {
            return null;
        }
        for (LootItemCondition condition : this.getConditions()) {
            if (condition.test((Object)context)) continue;
            return null;
        }
        ItemStack item = BuiltInRegistries.ITEM.getTag(((TagEntry)this.vanillaEntry).tag).flatMap(holders -> holders.getRandomElement(context.getRandom())).map(ItemStack::new).orElse(null);
        if (item == null || item.isEmpty()) {
            return null;
        }
        for (LootItemFunction function : this.getFunctions()) {
            item = (ItemStack)function.apply((Object)item, (Object)context);
        }
        return null;
    }

    @Override
    public void collectDebugInfo(DebugInfo info) {
        info.add("% Tag: " + this.getTag());
        super.collectDebugInfo(info);
    }
}

