/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.filters;

import com.almostreliable.lootjs.core.filters.ResourceLocationFilter;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.common.ToolAction;

public interface ItemFilter
extends Predicate<ItemStack> {
    public static final ItemFilter ALWAYS_FALSE = itemStack -> false;
    public static final ItemFilter ALWAYS_TRUE = itemStack -> true;
    public static final ItemFilter EMPTY = ItemStack::isEmpty;
    public static final ItemFilter SWORD = itemStack -> itemStack.getItem() instanceof SwordItem;
    public static final ItemFilter PICKAXE = itemStack -> itemStack.getItem() instanceof PickaxeItem;
    public static final ItemFilter AXE = itemStack -> itemStack.getItem() instanceof AxeItem;
    public static final ItemFilter SHOVEL = itemStack -> itemStack.getItem() instanceof ShovelItem;
    public static final ItemFilter HOE = itemStack -> itemStack.getItem() instanceof HoeItem;
    public static final ItemFilter TOOL = itemStack -> itemStack.getItem() instanceof DiggerItem;
    public static final ItemFilter POTION = itemStack -> itemStack.getItem() instanceof PotionItem;
    public static final ItemFilter HAS_TIER = itemStack -> itemStack.getItem() instanceof TieredItem;
    public static final ItemFilter PROJECTILE_WEAPON = itemStack -> itemStack.getItem() instanceof ProjectileWeaponItem;
    public static final ItemFilter ARMOR = itemStack -> itemStack.getItem() instanceof ArmorItem;
    public static final ItemFilter WEAPON = itemStack -> {
        Item i = itemStack.getItem();
        return i instanceof SwordItem || i instanceof DiggerItem || i instanceof ProjectileWeaponItem || i instanceof TridentItem;
    };
    public static final ItemFilter HEAD_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.HEAD);
    public static final ItemFilter CHEST_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.CHEST);
    public static final ItemFilter LEGS_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.LEGS);
    public static final ItemFilter FEET_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.FEET);
    public static final ItemFilter FOOD = ItemStack::isEdible;
    public static final ItemFilter DAMAGEABLE = ItemStack::isDamageableItem;
    public static final ItemFilter DAMAGED = ItemStack::isDamaged;
    public static final ItemFilter ENCHANTED = ItemStack::isEnchanted;
    public static final ItemFilter BLOCK_ITEM = itemStack -> itemStack.getItem() instanceof BlockItem;

    public static ItemFilter hasEnchantment(ResourceLocationFilter filter) {
        return ItemFilter.hasEnchantment(filter, MinMaxBounds.Ints.ANY);
    }

    public static ItemFilter hasEnchantment(ResourceLocationFilter filter, MinMaxBounds.Ints levelBounds) {
        return itemStack -> {
            ListTag listTag = itemStack.is(Items.ENCHANTED_BOOK) ? EnchantedBookItem.getEnchantments((ItemStack)itemStack) : itemStack.getEnchantmentTags();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.getCompound(i);
                ResourceLocation id = EnchantmentHelper.getEnchantmentId((CompoundTag)tag);
                int level = EnchantmentHelper.getEnchantmentLevel((CompoundTag)tag);
                if (id == null || !filter.test(id) || !levelBounds.matches(level)) continue;
                return true;
            }
            return false;
        };
    }

    public static ItemFilter tag(String tag) {
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        return new Tag((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(tag)));
    }

    public static ItemFilter equipmentSlot(EquipmentSlot slot) {
        return itemStack -> LivingEntity.getEquipmentSlotForItem((ItemStack)itemStack) == slot;
    }

    public static ItemFilter and(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].and(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (itemFilter.test(itemStack)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static ItemFilter not(ItemFilter itemFilter) {
        return itemFilter.negate();
    }

    public static ItemFilter or(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> ALWAYS_FALSE;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].or(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (!itemFilter.test(itemStack)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    public static ItemFilter custom(Predicate<ItemStack> predicate) {
        return predicate::test;
    }

    @Override
    public boolean test(ItemStack var1);

    default public ItemFilter and(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) && other.test(itemStack);
    }

    default public ItemFilter negate() {
        return itemS -> !this.test(itemS);
    }

    default public ItemFilter or(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) || other.test(itemStack);
    }

    public static ItemFilter canPerformAnyAction(String ... actions) {
        ToolAction[] toolActions = ItemFilter.getToolActions(actions);
        return itemStack -> {
            for (ToolAction action : toolActions) {
                if (!itemStack.canPerformAction(action)) continue;
                return true;
            }
            return false;
        };
    }

    public static ItemFilter canPerformAction(String ... actions) {
        ToolAction[] toolActions = ItemFilter.getToolActions(actions);
        return itemStack -> {
            for (ToolAction action : toolActions) {
                if (itemStack.canPerformAction(action)) continue;
                return false;
            }
            return true;
        };
    }

    private static ToolAction[] getToolActions(String[] actions) {
        ToolAction[] toolActions = new ToolAction[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            toolActions[i] = ToolAction.get((String)actions[i]);
        }
        return toolActions;
    }

    public record Tag(TagKey<Item> tag) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return itemStack.is(this.tag);
        }
    }

    public record Ingredient(net.minecraft.world.item.crafting.Ingredient ingredient) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return this.ingredient.test(itemStack);
        }
    }
}

