/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.filters;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public abstract class Resolver {
    protected final ResourceLocation value;

    Resolver(ResourceLocation value) {
        this.value = value;
    }

    public static Resolver of(String value) {
        if (value.startsWith("#")) {
            return new ByTagKey(new ResourceLocation(value.substring(1)));
        }
        return new ByEntry(new ResourceLocation(value));
    }

    public static class ByTagKey
    extends Resolver {
        ByTagKey(ResourceLocation value) {
            super(value);
        }

        public <T> TagKey<T> resolve(Registry<T> registry) {
            return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)this.value);
        }

        public <T> TagKey<T> resolve(ResourceKey<Registry<T>> resourceKey) {
            return TagKey.create(resourceKey, (ResourceLocation)this.value);
        }
    }

    public static class ByEntry
    extends Resolver {
        ByEntry(ResourceLocation value) {
            super(value);
        }

        public <T> T resolve(Registry<T> registry) {
            Object t = registry.get(this.value);
            if (t == null) {
                throw new IllegalArgumentException("No entry found for " + this.value);
            }
            return (T)t;
        }

        public <T> ResourceKey<T> resolve(ResourceKey<Registry<T>> resourceKey) {
            return ResourceKey.create(resourceKey, (ResourceLocation)this.value);
        }
    }
}

