/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.LootModificationsAPI;
import com.almostreliable.lootjs.core.ItemStackFactory;
import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.entry.SingleLootEntry;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.core.filters.Resolver;
import com.almostreliable.lootjs.core.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.kube.LootJSEvent;
import com.almostreliable.lootjs.kube.wrappers.ItemPredicateWrapper;
import com.almostreliable.lootjs.kube.wrappers.MinMaxBoundsWrapper;
import com.almostreliable.lootjs.kube.wrappers.MobEffectsPredicateWrapper;
import com.almostreliable.lootjs.kube.wrappers.StatePropsPredicateWrapper;
import com.almostreliable.lootjs.loot.LootCondition;
import com.almostreliable.lootjs.loot.LootFunction;
import com.almostreliable.lootjs.loot.Predicates;
import com.almostreliable.lootjs.loot.condition.builder.DistancePredicateBuilder;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;

public class LootJSPlugin
extends KubeJSPlugin {
    public static final EntityTypePredicate EMPTY_ENTITY_TYPE_PREDICATE = new EntityTypePredicate((HolderSet)HolderSet.direct((Holder[])new Holder[0]));

    public static boolean eventsAreDisabled() {
        return Boolean.getBoolean("lootjs.disable_events");
    }

    @Nullable
    public static <T extends Enum<T>> T valueOf(Class<T> clazz, Object o) {
        String s = o.toString();
        for (Enum constant : (Enum[])clazz.getEnumConstants()) {
            if (!s.equalsIgnoreCase(constant.name())) continue;
            return (T)constant;
        }
        return null;
    }

    private static ItemFilter ofItemFilterSingle(@Nullable Object o) {
        Ingredient ingredient;
        String str;
        if (o instanceof ItemFilter) {
            ItemFilter i = (ItemFilter)o;
            return i;
        }
        if (o instanceof String && !(str = (String)o).isEmpty()) {
            String first;
            switch (first = str.substring(0, 1)) {
                case "*": {
                    return ItemFilter.ALWAYS_TRUE;
                }
                case "#": {
                    ResourceLocation location = new ResourceLocation(str.substring(1));
                    TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
                    return new ItemFilter.Tag((TagKey<Item>)tag);
                }
                case "@": {
                    String modId = str.substring(1);
                    return itemStack -> itemStack.kjs$getMod().equals(modId);
                }
            }
        }
        if ((ingredient = IngredientJS.of((Object)o)).isEmpty()) {
            return ItemFilter.EMPTY;
        }
        return new ItemFilter.Ingredient(ingredient);
    }

    private static ItemFilter ofItemFilter(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>(list.size());
            for (Object entry : list) {
                ItemFilter filter = LootJSPlugin.ofItemFilter(entry);
                filters.add(filter);
            }
            return itemStack -> {
                for (ItemFilter filter : filters) {
                    if (!filter.test(itemStack)) continue;
                    return true;
                }
                return false;
            };
        }
        return LootJSPlugin.ofItemFilterSingle(o);
    }

    public void initStartup() {
        LootModificationsAPI.DEBUG_ACTION = s -> ConsoleJS.SERVER.info(s);
    }

    public void registerEvents() {
        LootJSEvent.GROUP.register();
    }

    public void registerBindings(BindingsEvent event) {
        event.add("LootType", LootType.class);
        event.add("ItemFilter", ItemFilter.class);
        event.add("LootEntry", LootEntry.class);
        event.add("LootCondition", LootCondition.class);
        event.add("LootFunction", LootFunction.class);
        event.add("IntBounds", MinMaxBounds.Ints.class);
        event.add("Bounds", MinMaxBounds.Doubles.class);
        event.add("Predicates", Predicates.class);
        event.add("ItemPredicate", ItemPredicate.class);
        event.add("EntityPredicate", EntityPredicate.class);
        event.add("EntityEquipmentPredicate", EntityEquipmentPredicate.class);
        event.add("LocationPredicate", LocationPredicate.class);
        event.add("DistancePredicate", DistancePredicate.class);
        event.add("BlockPredicate", BlockPredicate.class);
        event.add("FluidPredicate", FluidPredicate.class);
        event.add("LightPredicate", LightPredicate.class);
        event.add("EnchantmentPredicate", EnchantmentPredicate.class);
        event.add("MobEffectsPredicate", MobEffectsPredicate.class);
        event.add("NbtPredicate", NbtPredicate.class);
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.registerSimple(LootEntry.class, LootJSPlugin::ofLootEntry);
        typeWrappers.registerSimple(SingleLootEntry.class, LootJSPlugin::ofSingleLootEntry);
        typeWrappers.registerSimple(ItemStackFactory.class, LootJSPlugin::ofItemStackFactory);
        typeWrappers.registerSimple(MinMaxBounds.Doubles.class, MinMaxBoundsWrapper::ofMinMaxDoubles);
        typeWrappers.registerSimple(MinMaxBounds.Ints.class, MinMaxBoundsWrapper::ofMinMaxInt);
        typeWrappers.registerSimple(EntityTypePredicate.class, LootJSPlugin::ofEntityTypePredicate);
        typeWrappers.registerSimple(NbtPredicate.class, LootJSPlugin::ofNbtPredicate);
        typeWrappers.registerSimple(StatePropertiesPredicate.class, StatePropsPredicateWrapper::of);
        typeWrappers.registerSimple(StatePropertiesPredicate.Builder.class, StatePropsPredicateWrapper::ofBuilder);
        typeWrappers.registerSimple(MobEffectsPredicate.class, MobEffectsPredicateWrapper::of);
        typeWrappers.registerSimple(MobEffectsPredicate.Builder.class, MobEffectsPredicateWrapper::ofBuilder);
        typeWrappers.registerSimple(DistancePredicate.class, LootJSPlugin::ofDistancePredicate);
        typeWrappers.registerSimple(ItemPredicate.Builder.class, ItemPredicateWrapper::ofBuilder);
        typeWrappers.registerSimple(ItemPredicate.class, ItemPredicateWrapper::of);
        typeWrappers.registerSimple(ItemFilter.class, LootJSPlugin::ofItemFilter);
        typeWrappers.registerSimple(ResourceLocationFilter.class, this::ofResourceLocationFilter);
        typeWrappers.registerSimple(MapDecoration.Type.class, o -> LootJSPlugin.valueOf(MapDecoration.Type.class, o));
        typeWrappers.registerSimple(AttributeModifier.Operation.class, o -> LootJSPlugin.valueOf(AttributeModifier.Operation.class, o));
        typeWrappers.registerSimple(Resolver.class, o -> Resolver.of(o.toString()));
    }

    private static DistancePredicate ofDistancePredicate(Object o) {
        if (o instanceof DistancePredicate) {
            DistancePredicate distancePredicate = (DistancePredicate)o;
            return distancePredicate;
        }
        if (o instanceof DistancePredicateBuilder) {
            DistancePredicateBuilder distancePredicateBuilder = (DistancePredicateBuilder)o;
            return distancePredicateBuilder.build();
        }
        LootJS.LOG.warn("Invalid distance predicate: {}", o);
        return DistancePredicate.absolute((MinMaxBounds.Doubles)MinMaxBounds.Doubles.exactly((double)Double.MAX_VALUE));
    }

    private static NbtPredicate ofNbtPredicate(@Nullable Object o) {
        if (o instanceof NbtPredicate) {
            NbtPredicate nbt = (NbtPredicate)o;
            return nbt;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return new NbtPredicate((CompoundTag)NBTUtils.compoundTag((Map)map));
        }
        return new NbtPredicate(new CompoundTag());
    }

    private ResourceLocationFilter ofResourceLocationFilter(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            return new ResourceLocationFilter.Or(list.stream().map(this::ofResourceLocationFilter).toList());
        }
        Pattern pattern = UtilsJS.parseRegex((Object)o);
        if (pattern == null) {
            return new ResourceLocationFilter.ByLocation(new ResourceLocation(o.toString()));
        }
        return new ResourceLocationFilter.ByPattern(pattern);
    }

    private static ItemStackFactory ofItemStackFactory(@Nullable Object o) {
        if (o instanceof ItemStackFactory) {
            ItemStackFactory factory = (ItemStackFactory)o;
            return factory;
        }
        ItemStack itemStack = ItemStackJS.of((Object)o);
        if (itemStack.isEmpty()) {
            return ItemStackFactory.EMPTY;
        }
        return context -> itemStack;
    }

    public static SingleLootEntry ofSingleLootEntry(@Nullable Object o) {
        if (o instanceof SingleLootEntry) {
            SingleLootEntry e = (SingleLootEntry)o;
            return e;
        }
        ItemStack itemStack = ItemStackJS.of((Object)o);
        if (itemStack.isEmpty()) {
            ConsoleJS.SERVER.error((Object)("[LootEntry.of()] Invalid item stack, returning empty stack: " + o));
            ConsoleJS.SERVER.error((Object)"- Consider using `LootEntry.empty()` if you want to create an empty loot entry.");
            return LootEntry.empty();
        }
        return LootEntry.of(itemStack);
    }

    public static LootEntry ofLootEntry(@Nullable Object o) {
        String str;
        if (o instanceof LootEntry) {
            LootEntry entry = (LootEntry)o;
            return entry;
        }
        if (o instanceof String && (str = (String)o).startsWith("#")) {
            String tag = str.substring(0, 1);
            return LootEntry.tag(tag, false);
        }
        return LootJSPlugin.ofSingleLootEntry(o);
    }

    public static EntityTypePredicate ofEntityTypePredicate(@Nullable Object o) {
        if (o instanceof EntityType) {
            EntityType type = (EntityType)o;
            return EntityTypePredicate.of((EntityType)type);
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            if (tag.registry() != Registries.ENTITY_TYPE) {
                throw new IllegalArgumentException("Provided tag is not an entity type tag: " + tag);
            }
            return EntityTypePredicate.of((TagKey)tag);
        }
        if (o instanceof String) {
            String str = (String)o;
            if (str.startsWith("#")) {
                ResourceLocation tag = new ResourceLocation(str.substring(1));
                return EntityTypePredicate.of((TagKey)TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)tag));
            }
            EntityType et = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation(str));
            return EntityTypePredicate.of((EntityType)et);
        }
        if (o instanceof List) {
            List list = (List)o;
            ArrayList<HolderSet> predicates = new ArrayList<HolderSet>();
            for (Object object : list) {
                EntityTypePredicate p = LootJSPlugin.ofEntityTypePredicate(object);
                predicates.add(p.types());
            }
            return new EntityTypePredicate((HolderSet)new OrHolderSet(predicates));
        }
        LootJS.LOG.error("Failed creating EntityTypePredicate. Will return empty one");
        return EMPTY_ENTITY_TYPE_PREDICATE;
    }

    private static <T, B> void createBuilderWrapper(TypeWrappers wrappers, Class<T> goalClazz, Class<B> builderClazz, Function<B, T> buildFunc) {
        wrappers.registerSimple(goalClazz, new BuilderTypeWrapper<T, B>(goalClazz, builderClazz, buildFunc));
    }

    private record BuilderTypeWrapper<T, B>(Class<T> goalClazz, Class<B> builderClazz, Function<B, T> buildFunc) implements TypeWrapperFactory.Simple<T>
    {
        public T wrapSimple(Object o) {
            if (this.goalClazz.isInstance(o)) {
                return this.goalClazz().cast(o);
            }
            if (this.builderClazz.isInstance(o)) {
                return this.buildFunc().apply(this.builderClazz.cast(o));
            }
            throw new IllegalArgumentException("LootJS Type Error. Could not build or direct cast into " + this.goalClazz.getSimpleName() + ", got: " + o);
        }
    }
}

