/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootModificationsAPI;
import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.kube.LootJSPlugin;
import com.almostreliable.lootjs.loot.modifier.LootModifier;
import com.almostreliable.lootjs.util.Utils;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.apache.commons.lang3.StringUtils;

public class LootModificationEventJS
extends EventJS {
    private final Map<ResourceLocation, IGlobalLootModifier> modifiers;
    private final List<ResourceLocation> removedGlobalModifiers = new ArrayList<ResourceLocation>();
    private final List<LootModifier.Builder> modifierBuilders = new ArrayList<LootModifier.Builder>();

    public LootModificationEventJS(Map<ResourceLocation, IGlobalLootModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public List<String> getGlobalModifiers() {
        return this.modifiers.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public void removeGlobalModifier(String ... locationOrModIds) {
        HashSet<String> modIds = new HashSet<String>();
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        for (String locationOrModId : locationOrModIds) {
            if (locationOrModId.startsWith("@")) {
                modIds.add(locationOrModId.substring(1));
                continue;
            }
            locations.add(new ResourceLocation(locationOrModId));
        }
        Set<ResourceLocation> collectedByModIds = this.modifiers.keySet().stream().filter(rl -> modIds.contains(rl.getNamespace())).collect(Collectors.toSet());
        Set<ResourceLocation> collectedByLocations = this.modifiers.keySet().stream().filter(locations::contains).collect(Collectors.toSet());
        this.remove(collectedByModIds);
        this.remove(collectedByLocations);
    }

    private void remove(Set<ResourceLocation> locations) {
        locations.forEach(this.modifiers::remove);
        this.removedGlobalModifiers.addAll(locations);
    }

    public void enableLogging() {
        LootModificationsAPI.DEBUG_LOOT_MODIFIERS = true;
    }

    public void disableLootModification(ResourceLocationFilter ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("No loot table were given.");
        }
        LootModificationsAPI.FILTERS.addAll(Arrays.asList(filters));
    }

    public LootModifier.Builder addTableModifier(ResourceLocationFilter ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("No loot table were given.");
        }
        LootModifier.Builder builder = new LootModifier.Builder(new LootModifier.TableFiltered(filters), Utils.quote("LootTables", Arrays.asList(filters)));
        this.modifierBuilders.add(builder);
        return builder;
    }

    public LootModifier.Builder addTypeModifier(LootType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("No loot type were given.");
        }
        LootModifier.Builder builder = new LootModifier.Builder(new LootModifier.TypeFiltered(types), Utils.quote("Types", Arrays.asList(types)));
        this.modifierBuilders.add(builder);
        return builder;
    }

    public LootModifier.Builder addBlockModifier(Object o) {
        Preconditions.checkNotNull((Object)o);
        BlockStatePredicate blockStatePredicate = BlockStatePredicate.of((Object)o);
        LootModifier.Builder builder = new LootModifier.Builder(new LootModifier.BlockFiltered((Predicate<BlockState>)blockStatePredicate), "BlocksPredicate for: " + StringUtils.abbreviate((String)o.toString(), (int)50));
        this.modifierBuilders.add(builder);
        return builder;
    }

    public LootModifier.Builder addEntityModifier(EntityType<?> ... entities) {
        Set<EntityType<?>> set = Arrays.stream(entities).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set.isEmpty()) {
            throw new IllegalArgumentException("No valid entities given.");
        }
        List entityIds = set.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0)).collect(Collectors.toList());
        LootModifier.Builder builder = new LootModifier.Builder(new LootModifier.EntityFiltered(set), Utils.quote("Entities", entityIds));
        this.modifierBuilders.add(builder);
        return builder;
    }

    public void disableWitherStarDrop() {
        LootModificationsAPI.DISABLE_WITHER_DROPPING_NETHER_STAR = true;
    }

    public void disableCreeperHeadDrop() {
        LootModificationsAPI.DISABLE_CREEPER_DROPPING_HEAD = true;
    }

    public void disableSkeletonHeadDrop() {
        LootModificationsAPI.DISABLE_SKELETON_DROPPING_HEAD = true;
    }

    public void disableZombieHeadDrop() {
        LootModificationsAPI.DISABLE_ZOMBIE_DROPPING_HEAD = true;
    }

    protected void afterPosted(EventResult result) {
        super.afterPosted(result);
        if (LootJSPlugin.eventsAreDisabled()) {
            return;
        }
        if (!this.removedGlobalModifiers.isEmpty()) {
            ConsoleJS.SERVER.info((Object)("[LootJS] Removed " + this.removedGlobalModifiers.size() + " global loot modifiers: " + this.removedGlobalModifiers.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))));
        }
        try {
            for (LootModifier.Builder b : this.modifierBuilders) {
                LootModificationsAPI.addModification(b.build());
            }
        }
        catch (Exception exception) {
            ConsoleJS.SERVER.error((Object)exception);
        }
    }
}

