/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.loot.table.LootTableList;
import com.almostreliable.lootjs.loot.table.MutableLootTable;
import com.almostreliable.lootjs.mixin.LootDataManagerAccessor;
import com.almostreliable.lootjs.util.Utils;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class LootTableEventJS
extends EventJS {
    private final Map<LootDataId<?>, ?> rawData;
    private final Map<ResourceLocation, MutableLootTable> lootTableHolders = new HashMap<ResourceLocation, MutableLootTable>();
    private final LootDataManager manager;
    @Nullable
    private Map<LootDataId<?>, ?> unwrappedData;

    public LootTableEventJS(LootDataManager manager) {
        this.manager = manager;
        LootDataManagerAccessor accessor = (LootDataManagerAccessor)manager;
        this.rawData = accessor.getElements();
    }

    private Map<LootDataId<?>, ?> getData() {
        if (this.unwrappedData != null) {
            return this.unwrappedData;
        }
        return this.rawData;
    }

    private void unwrapData() {
        if (this.unwrappedData != null) {
            return;
        }
        this.unwrappedData = new HashMap();
        this.rawData.forEach((id, entry) -> this.unwrappedData.put((LootDataId<?>)id, Utils.cast(entry)));
    }

    public Set<ResourceLocation> getLootTableIds() {
        return this.getLootTableIds(location -> true);
    }

    public Set<ResourceLocation> getLootTableIds(ResourceLocationFilter filter) {
        return this.getData().keySet().stream().filter(id -> id.type() == LootDataType.TABLE).map(LootDataId::location).filter(filter).collect(Collectors.toSet());
    }

    public void forEachTable(ResourceLocationFilter filter, Consumer<MutableLootTable> onForEach) {
        this.getLootTableIds(filter).forEach(location -> {
            MutableLootTable table = this.getLootTable((ResourceLocation)location);
            if (table != null) {
                onForEach.accept(table);
            }
        });
    }

    public void forEachTable(Consumer<MutableLootTable> onForEach) {
        this.forEachTable(location -> true, onForEach);
    }

    public boolean hasLootTable(ResourceLocation location) {
        return this.getData().containsKey(new LootDataId(LootDataType.TABLE, location));
    }

    public void clearLootTables(ResourceLocationFilter filter) {
        for (LootDataId<?> id : this.getData().keySet()) {
            MutableLootTable table;
            if (id.type() != LootDataType.TABLE || (table = this.getLootTable(id.location())) == null) continue;
            table.clear();
        }
    }

    @Nullable
    public MutableLootTable getLootTable(ResourceLocation location) {
        LootDataId dataId = new LootDataId(LootDataType.TABLE, location);
        if (!this.getData().containsKey(dataId)) {
            return null;
        }
        if (LootDataManager.EMPTY_LOOT_TABLE_KEY.equals((Object)dataId)) {
            return null;
        }
        return this.lootTableHolders.computeIfAbsent(location, rl -> {
            Object entry = this.getData().get(dataId);
            if (entry instanceof LootTable) {
                LootTable table = (LootTable)entry;
                return new MutableLootTable(table, location);
            }
            throw new RuntimeException("[Internal LootJS Error] Loot table not found: " + rl);
        });
    }

    @Nullable
    public MutableLootTable getBlockTable(Block block) {
        return this.getLootTable(block.getLootTable());
    }

    @Nullable
    public MutableLootTable getEntityTable(EntityType<?> entityType) {
        return this.getLootTable(entityType.getDefaultLootTable());
    }

    public LootTableList modifyLootTables(ResourceLocationFilter filter) {
        Stream<MutableLootTable> tables = this.getData().keySet().stream().filter(id -> filter.test(id.location())).map(id -> this.getLootTable(id.location()));
        return new LootTableList(tables);
    }

    public LootTableList modifyBlockTables(BlockStatePredicate filter) {
        Stream<MutableLootTable> tables = filter.getBlocks().stream().map(this::getBlockTable);
        return new LootTableList(tables);
    }

    public LootTableList modifyEntityTables(EntityTypePredicate filter) {
        Stream<MutableLootTable> tables = BuiltInRegistries.ENTITY_TYPE.stream().filter(arg_0 -> ((EntityTypePredicate)filter).matches(arg_0)).map(this::getEntityTable);
        return new LootTableList(tables);
    }

    public LootTableList modifyLootTypeTables(LootType ... types) {
        HashSet<LootType> asSet = new HashSet<LootType>(Arrays.asList(types));
        Stream<MutableLootTable> tables = this.getData().keySet().stream().map(id -> this.getLootTable(id.location())).filter(table -> table != null && asSet.contains((Object)table.getLootType()));
        return new LootTableList(tables);
    }

    public MutableLootTable create(ResourceLocation location) {
        return this.create(location, LootType.CHEST);
    }

    public MutableLootTable create(ResourceLocation location, LootType type) {
        if (this.hasLootTable(location)) {
            throw new RuntimeException("[LootJS Error] Loot table already exists, cannot create new one: " + location);
        }
        LootContextParamSet paramSet = type.getParamSet();
        this.unwrapData();
        LootTable lootTable = new LootTable.Builder().setParamSet(paramSet).setRandomSequence(location).build();
        if (lootTable.getLootTableId() == null) {
            lootTable.setLootTableId(location);
        }
        this.getData().put(new LootDataId(LootDataType.TABLE, location), Utils.cast(lootTable));
        MutableLootTable table = new MutableLootTable(lootTable, location);
        table.markDirty();
        if (this.lootTableHolders.put(location, table) != null) {
            throw new IllegalStateException("Loot table already exists: " + location);
        }
        return table;
    }

    protected void afterPosted(EventResult result) {
        super.afterPosted(result);
        this.lootTableHolders.forEach((location, table) -> {
            try {
                if (table.isDirty()) {
                    table.writeToVanillaTable();
                    ConsoleJS.SERVER.info((Object)("Re-applied modified loot table to vanilla: " + location));
                }
            }
            catch (Exception e) {
                ConsoleJS.SERVER.error("Error while re-applying modified loot table to vanilla: " + location, (Throwable)e);
            }
        });
        if (this.unwrappedData != null) {
            ((LootDataManagerAccessor)this.manager).setElements(this.unwrappedData);
        }
    }
}

