/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube.wrappers;

import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.advancements.critereon.ICustomItemPredicate;

public class ItemPredicateWrapper {
    public static ItemPredicate.Builder ofBuilder(@Nullable Object o) {
        if (o instanceof ItemPredicate.Builder) {
            ItemPredicate.Builder b = (ItemPredicate.Builder)o;
            return b;
        }
        return new SelfBuilder(ItemPredicateWrapper.of(o));
    }

    public static ItemPredicate of(@Nullable Object o) {
        String str;
        if (o instanceof ItemPredicate) {
            ItemPredicate i = (ItemPredicate)o;
            return i;
        }
        if (o instanceof ItemFilter) {
            ItemFilter filter = (ItemFilter)o;
            new ItemPredicate((ICustomItemPredicate)new ItemFilterPredicate(filter));
        }
        if (o instanceof String && !(str = (String)o).isEmpty()) {
            String first;
            switch (first = str.substring(0, 1)) {
                case "#": {
                    ResourceLocation location = new ResourceLocation(str.substring(1));
                    TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
                    return new ItemPredicate(Optional.of(tag), Optional.empty(), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, List.of(), List.of(), Optional.empty(), Optional.empty());
                }
                case "@": {
                    String modId = str.substring(1);
                    ItemFilter filter = itemStack -> itemStack.kjs$getMod().equals(modId);
                    return new ItemPredicate((ICustomItemPredicate)new ItemFilterPredicate(filter));
                }
            }
        }
        Object[] items = IngredientJS.of((Object)o).getItems();
        Optional<HolderSet.Direct> holders = Optional.of(HolderSet.direct(ItemStack::getItemHolder, (Object[])items));
        return new ItemPredicate(Optional.empty(), holders, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, List.of(), List.of(), Optional.empty(), Optional.empty());
    }

    private static class SelfBuilder
    extends ItemPredicate.Builder {
        private final ItemPredicate predicate;

        public SelfBuilder(ItemPredicate predicate) {
            this.predicate = predicate;
        }

        public ItemPredicate build() {
            return this.predicate;
        }
    }

    private record ItemFilterPredicate(ItemFilter filter) implements ICustomItemPredicate
    {
        private static final ItemFilterPredicate INSTANCE = new ItemFilterPredicate(ItemFilter.ALWAYS_FALSE);
        private static final Codec<ItemFilterPredicate> CODEC = Codec.unit((Object)INSTANCE);

        public Codec<? extends ICustomItemPredicate> codec() {
            return CODEC;
        }

        public boolean test(ItemStack itemStack) {
            return this.filter.test(itemStack);
        }
    }
}

