/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube.wrappers;

import com.almostreliable.lootjs.kube.wrappers.MinMaxBoundsWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public class MobEffectsPredicateWrapper {
    public static MobEffectsPredicate.Builder ofBuilder(@Nullable Object o) {
        if (o instanceof MobEffectsPredicate.Builder) {
            MobEffectsPredicate.Builder b = (MobEffectsPredicate.Builder)o;
            return b;
        }
        MobEffectsPredicate.Builder effects = MobEffectsPredicate.Builder.effects();
        MobEffectsPredicateWrapper.write(o, (h, p) -> effects.and((MobEffect)h.value(), p));
        return effects;
    }

    public static MobEffectsPredicate of(@Nullable Object o) {
        if (o instanceof MobEffectsPredicate.Builder) {
            MobEffectsPredicate.Builder b = (MobEffectsPredicate.Builder)o;
            return (MobEffectsPredicate)b.build().get();
        }
        if (o instanceof MobEffectsPredicate) {
            MobEffectsPredicate m = (MobEffectsPredicate)o;
            return m;
        }
        HashMap effectMap = new HashMap();
        MobEffectsPredicateWrapper.write(o, effectMap::put);
        return new MobEffectsPredicate(effectMap);
    }

    private static void write(@Nullable Object o, BiConsumer<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> onAdd) {
        if (o instanceof List) {
            List list = (List)o;
            for (Object entry : list) {
                MobEffectsPredicateWrapper.writeSingle(entry, onAdd);
            }
            return;
        }
        MobEffectsPredicateWrapper.writeSingle(o, onAdd);
    }

    private static void writeSingle(@Nullable Object o, BiConsumer<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> onAdd) {
        if (o instanceof String) {
            String str = (String)o;
            MobEffectsPredicateWrapper.getEffect(str).ifPresent(h -> onAdd.accept((Holder<MobEffect>)h, new MobEffectsPredicate.MobEffectInstancePredicate()));
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            MobEffectsPredicateWrapper.getEffect(map.get("id")).ifPresent(h -> onAdd.accept((Holder<MobEffect>)h, MobEffectsPredicateWrapper.createPredicate(map)));
        }
    }

    private static Optional<? extends Holder<MobEffect>> getEffect(@Nullable Object o) {
        if (!(o instanceof String)) {
            return Optional.empty();
        }
        String str = (String)o;
        return BuiltInRegistries.MOB_EFFECT.getHolder(ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)new ResourceLocation(str)));
    }

    @Nullable
    private static Boolean tryGetBoolean(@Nullable Object o) {
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b;
        }
        return null;
    }

    private static MobEffectsPredicate.MobEffectInstancePredicate createPredicate(Map<?, ?> map) {
        MinMaxBounds.Ints amplifier = MinMaxBoundsWrapper.ofMinMaxInt(map.get("amplifier"));
        MinMaxBounds.Ints duration = MinMaxBoundsWrapper.ofMinMaxInt(map.get("duration"));
        Boolean a = MobEffectsPredicateWrapper.tryGetBoolean(map.get("ambient"));
        Boolean v = MobEffectsPredicateWrapper.tryGetBoolean(map.get("visible"));
        return new MobEffectsPredicate.MobEffectInstancePredicate(amplifier, duration, Optional.ofNullable(a), Optional.ofNullable(v));
    }
}

