/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.core.filters.Resolver;
import com.almostreliable.lootjs.loot.condition.AnyBiomeCheck;
import com.almostreliable.lootjs.loot.condition.AnyDimension;
import com.almostreliable.lootjs.loot.condition.AnyStructure;
import com.almostreliable.lootjs.loot.condition.BiomeCheck;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.MainHandTableBonus;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.stages.Stages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.apache.logging.log4j.Logger;

public class LootCondition {
    public static LootItemCondition matchTool(ItemPredicate predicate) {
        return new MatchTool(Optional.of(predicate));
    }

    public static LootItemCondition matchMainHand(ItemFilter filter) {
        return new MatchEquipmentSlot(EquipmentSlot.MAINHAND, filter);
    }

    public static LootItemCondition matchOffHand(ItemFilter filter) {
        return new MatchEquipmentSlot(EquipmentSlot.OFFHAND, filter);
    }

    public static LootItemCondition matchHead(ItemFilter filter) {
        return new MatchEquipmentSlot(EquipmentSlot.HEAD, filter);
    }

    public static LootItemCondition matchChest(ItemFilter filter) {
        return new MatchEquipmentSlot(EquipmentSlot.CHEST, filter);
    }

    public static LootItemCondition matchLegs(ItemFilter filter) {
        return new MatchEquipmentSlot(EquipmentSlot.LEGS, filter);
    }

    public static LootItemCondition matchFeet(ItemFilter filter) {
        return new MatchEquipmentSlot(EquipmentSlot.FEET, filter);
    }

    public static LootItemCondition matchEquip(EquipmentSlot slot, ItemFilter filter) {
        return new MatchEquipmentSlot(slot, filter);
    }

    public static LootItemCondition survivesExplosion() {
        return ExplosionCondition.survivesExplosion().build();
    }

    public static LootItemCondition timeCheck(long period, int min, int max) {
        return new TimeCheck.Builder(IntRange.range((int)min, (int)max)).setPeriod(period).build();
    }

    public static LootItemCondition timeCheck(int min, int max) {
        return LootCondition.timeCheck(24000L, min, max);
    }

    public static LootItemCondition weatherCheck(Map<String, Boolean> map) {
        Boolean isRaining = map.getOrDefault("raining", null);
        Boolean isThundering = map.getOrDefault("thundering", null);
        return LootCondition.weatherCheck(isRaining, isThundering);
    }

    public static LootItemCondition weatherCheck(@Nullable Boolean raining, @Nullable Boolean thundering) {
        WeatherCheck.Builder builder = new WeatherCheck.Builder();
        if (raining != null) {
            builder.setRaining(raining.booleanValue());
        }
        if (thundering != null) {
            builder.setThundering(thundering.booleanValue());
        }
        return builder.build();
    }

    public static LootItemCondition randomChance(float value) {
        return LootItemRandomChanceCondition.randomChance((float)value).build();
    }

    public static LootItemCondition randomChanceWithLooting(float value, float looting) {
        return LootItemRandomChanceWithLootingCondition.randomChanceAndLootingBoost((float)value, (float)looting).build();
    }

    public static LootItemCondition randomChanceWithEnchantment(@Nullable Enchantment enchantment, float[] chances) {
        if (enchantment == null) {
            throw new IllegalArgumentException("Enchant not found");
        }
        return new MainHandTableBonus(enchantment, chances);
    }

    public static LootItemCondition location(LocationPredicate.Builder predicate) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)predicate).build();
    }

    public static LootItemCondition location(BlockPos offset, LocationPredicate.Builder predicate) {
        return LocationCheck.checkLocation((LocationPredicate.Builder)predicate, (BlockPos)offset).build();
    }

    public static LootItemCondition biome(Resolver ... resolvers) {
        ArrayList<ResourceKey<Biome>> biomes = new ArrayList<ResourceKey<Biome>>();
        ArrayList<TagKey<Biome>> tagKeys = new ArrayList<TagKey<Biome>>();
        for (Resolver resolver : resolvers) {
            if (resolver instanceof Resolver.ByEntry) {
                Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
                biomes.add(byEntry.resolve(Registries.BIOME));
                continue;
            }
            if (!(resolver instanceof Resolver.ByTagKey)) continue;
            Resolver.ByTagKey byTagKey = (Resolver.ByTagKey)resolver;
            tagKeys.add(byTagKey.resolve(Registries.BIOME));
        }
        return new BiomeCheck(biomes, tagKeys);
    }

    public static LootItemCondition anyBiome(Resolver ... resolvers) {
        ArrayList<ResourceKey<Biome>> biomes = new ArrayList<ResourceKey<Biome>>();
        ArrayList<TagKey<Biome>> tagKeys = new ArrayList<TagKey<Biome>>();
        for (Resolver resolver : resolvers) {
            if (resolver instanceof Resolver.ByEntry) {
                Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
                biomes.add(byEntry.resolve(Registries.BIOME));
                continue;
            }
            if (!(resolver instanceof Resolver.ByTagKey)) continue;
            Resolver.ByTagKey byTagKey = (Resolver.ByTagKey)resolver;
            tagKeys.add(byTagKey.resolve(Registries.BIOME));
        }
        return new AnyBiomeCheck(biomes, tagKeys);
    }

    public static LootItemCondition anyDimension(ResourceLocation ... dimensions) {
        return new AnyDimension(dimensions);
    }

    public static LootItemCondition anyStructure(String[] idOrTags, boolean exact) {
        AnyStructure.Builder builder = new AnyStructure.Builder();
        for (String s : idOrTags) {
            builder.add(s);
        }
        return builder.build(exact);
    }

    public static LootItemCondition lightLevel(int min, int max) {
        return new IsLightLevel(min, max);
    }

    public static LootItemCondition luck(MinMaxBounds.Doubles bounds) {
        return LootCondition.customPlayerCheck(serverPlayer -> bounds.matches((double)serverPlayer.getLuck()));
    }

    public static LootItemCondition killedByPlayer() {
        return LootItemKilledByPlayerCondition.killedByPlayer().build();
    }

    public static LootItemCondition matchBlockState(Block block, StatePropertiesPredicate.Builder properties) {
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(properties).build();
    }

    public static LootItemCondition matchEntity(EntityPredicate.Builder entityPredicate) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityPredicate).build();
    }

    public static LootItemCondition matchKiller(EntityPredicate.Builder entityPredicate) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)entityPredicate).build();
    }

    public static LootItemCondition matchDirectKiller(EntityPredicate.Builder entityPredicate) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_KILLER, (EntityPredicate.Builder)entityPredicate).build();
    }

    public static LootItemCondition matchPlayer(EntityPredicate.Builder entityPredicate) {
        return new MatchPlayer(entityPredicate.build());
    }

    public static LootItemCondition matchDamageSource(DamageSourcePredicate.Builder predicate) {
        return DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)predicate).build();
    }

    public static LootItemCondition distance(MinMaxBounds.Doubles bounds) {
        return LootCondition.customDistance(new DistancePredicate(MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, bounds));
    }

    public static LootItemCondition customDistance(DistancePredicate predicate) {
        return new MatchKillerDistance(predicate);
    }

    public static LootItemCondition customPlayerCheck(Predicate<ServerPlayer> predicate) {
        return new PlayerParamPredicate(predicate);
    }

    public static LootItemCondition customEntityCheck(Predicate<Entity> predicate) {
        return new CustomParamPredicate<Entity>(LootContextParams.THIS_ENTITY, predicate);
    }

    public static LootItemCondition customKillerCheck(Predicate<Entity> predicate) {
        return new CustomParamPredicate<Entity>(LootContextParams.KILLER_ENTITY, predicate);
    }

    public static LootItemCondition customDirectKillerCheck(Predicate<Entity> predicate) {
        return new CustomParamPredicate<Entity>(LootContextParams.DIRECT_KILLER_ENTITY, predicate);
    }

    public static LootItemCondition blockEntity(Predicate<BlockEntity> predicate) {
        return new CustomParamPredicate<BlockEntity>(LootContextParams.BLOCK_ENTITY, predicate);
    }

    public static LootItemCondition hasAnyStage(String ... stages) {
        if (stages.length == 1) {
            String stage = stages[0];
            return new PlayerParamPredicate(player -> Stages.get((Player)player).has(stage));
        }
        return new PlayerParamPredicate(player -> {
            for (String stage : stages) {
                if (!Stages.get((Player)player).has(stage)) continue;
                return true;
            }
            return false;
        });
    }

    public static LootItemCondition fromJson(JsonObject json) {
        return (LootItemCondition)LootItemConditions.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)LootJS.LOG).error(arg_0));
    }

    public static LootItemCondition or(LootItemCondition ... conditions) {
        return new AnyOfCondition(Arrays.asList(conditions));
    }

    public static LootItemCondition and(LootItemCondition ... conditions) {
        return new AllOfCondition(Arrays.asList(conditions));
    }
}

