/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.core.filters.Resolver;
import com.almostreliable.lootjs.loot.LootCondition;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public interface LootConditionsContainer<B extends LootConditionsContainer<?>> {
    default public B matchTool(ItemPredicate predicate) {
        return this.addCondition(LootCondition.matchTool(predicate));
    }

    default public B matchMainHand(ItemFilter filter) {
        return this.addCondition(LootCondition.matchMainHand(filter));
    }

    default public B matchOffHand(ItemFilter filter) {
        return this.addCondition(LootCondition.matchOffHand(filter));
    }

    default public B matchEquip(EquipmentSlot slot, ItemFilter filter) {
        return this.addCondition(LootCondition.matchEquip(slot, filter));
    }

    default public B survivesExplosion() {
        return this.addCondition(LootCondition.survivesExplosion());
    }

    default public B timeCheck(long period, int min, int max) {
        return this.addCondition(LootCondition.timeCheck(period, min, max));
    }

    default public B timeCheck(int min, int max) {
        return this.addCondition(LootCondition.timeCheck(min, max));
    }

    default public B weatherCheck(Map<String, Boolean> map) {
        return this.addCondition(LootCondition.weatherCheck(map));
    }

    default public B weatherCheck(Boolean isRaining, Boolean isThundering) {
        return this.addCondition(LootCondition.weatherCheck(isRaining, isThundering));
    }

    default public B randomChance(float value) {
        return this.addCondition(LootCondition.randomChance(value));
    }

    default public B randomChanceWithLooting(float value, float looting) {
        return this.addCondition(LootCondition.randomChanceWithLooting(value, looting));
    }

    default public B randomChanceWithEnchantment(@Nullable Enchantment enchantment, float[] chances) {
        return this.addCondition(LootCondition.randomChanceWithEnchantment(enchantment, chances));
    }

    default public B location(LocationPredicate.Builder predicate) {
        return this.addCondition(LootCondition.location(predicate));
    }

    default public B location(BlockPos offset, LocationPredicate.Builder predicate) {
        return this.addCondition(LootCondition.location(offset, predicate));
    }

    default public B biome(Resolver ... resolvers) {
        return this.addCondition(LootCondition.biome(resolvers));
    }

    default public B anyBiome(Resolver ... resolvers) {
        return this.addCondition(LootCondition.anyBiome(resolvers));
    }

    default public B anyDimension(ResourceLocation ... dimensions) {
        return this.addCondition(LootCondition.anyDimension(dimensions));
    }

    default public B anyStructure(String[] idOrTags, boolean exact) {
        return this.addCondition(LootCondition.anyStructure(idOrTags, exact));
    }

    default public B lightLevel(int min, int max) {
        return this.addCondition(LootCondition.lightLevel(min, max));
    }

    default public B killedByPlayer() {
        return this.addCondition(LootCondition.killedByPlayer());
    }

    default public B matchBlockState(Block block, StatePropertiesPredicate.Builder properties) {
        return this.addCondition(LootCondition.matchBlockState(block, properties));
    }

    default public B matchFluid(Resolver resolver) {
        throw new UnsupportedOperationException("Not implemented currently.");
    }

    default public B matchEntity(EntityPredicate.Builder entityPredicate) {
        return this.addCondition(LootCondition.matchEntity(entityPredicate));
    }

    default public B matchKiller(EntityPredicate.Builder entityPredicate) {
        return this.addCondition(LootCondition.matchKiller(entityPredicate));
    }

    default public B matchDirectKiller(EntityPredicate.Builder entityPredicate) {
        return this.addCondition(LootCondition.matchDirectKiller(entityPredicate));
    }

    default public B matchPlayer(EntityPredicate.Builder entityPredicate) {
        return this.addCondition(LootCondition.matchPlayer(entityPredicate));
    }

    default public B matchDamageSource(DamageSourcePredicate.Builder predicate) {
        return this.addCondition(LootCondition.matchDamageSource(predicate));
    }

    default public B distance(MinMaxBounds.Doubles bounds) {
        return this.addCondition(LootCondition.distance(bounds));
    }

    default public B customDistance(DistancePredicate predicate) {
        return this.addCondition(LootCondition.customDistance(predicate));
    }

    default public B customPlayerCheck(Predicate<ServerPlayer> predicate) {
        return this.addCondition(LootCondition.customPlayerCheck(predicate));
    }

    default public B customEntityCheck(Predicate<Entity> predicate) {
        return this.addCondition(LootCondition.customEntityCheck(predicate));
    }

    default public B customKillerCheck(Predicate<Entity> predicate) {
        return this.addCondition(LootCondition.customKillerCheck(predicate));
    }

    default public B customDirectKillerCheck(Predicate<Entity> predicate) {
        return this.addCondition(LootCondition.customDirectKillerCheck(predicate));
    }

    default public B blockEntityPredicate(Predicate<BlockEntity> predicate) {
        return this.addCondition(LootCondition.blockEntity(predicate));
    }

    default public B hasAnyStage(String ... stages) {
        return this.addCondition(LootCondition.hasAnyStage(stages));
    }

    default public B or(Consumer<LootConditionsContainer<B>> action) {
        List<LootItemCondition> conditions = this.createConditions(action);
        LootItemCondition[] array = conditions.toArray(new LootItemCondition[0]);
        return this.addCondition(LootCondition.or(array));
    }

    default public B and(Consumer<LootConditionsContainer<B>> action) {
        List<LootItemCondition> conditions = this.createConditions(action);
        LootItemCondition[] array = conditions.toArray(new LootItemCondition[0]);
        return this.addCondition(LootCondition.and(array));
    }

    default public List<LootItemCondition> createConditions(Consumer<LootConditionsContainer<B>> action) {
        final ArrayList<LootItemCondition> conditions = new ArrayList<LootItemCondition>();
        LootConditionsContainer container = new LootConditionsContainer<B>(){

            @Override
            public B addCondition(LootItemCondition condition) {
                conditions.add(condition);
                return this;
            }
        };
        action.accept(container);
        return conditions;
    }

    default public B jsonCondition(JsonObject json) {
        return this.addCondition(LootCondition.fromJson(json));
    }

    public B addCondition(LootItemCondition var1);
}

