/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.loot.AddAttributesFunction;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetLoreFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.logging.log4j.Logger;

public class LootFunction {
    public static LootItemFunction enchantRandomly() {
        return LootFunction.enchantRandomly(new Enchantment[0]);
    }

    public static LootItemFunction enchantRandomly(Enchantment[] enchantments) {
        EnchantRandomlyFunction.Builder enchantRandomlyFunctionBuilder = EnchantRandomlyFunction.randomEnchantment();
        for (Enchantment enchantment : enchantments) {
            enchantRandomlyFunctionBuilder.withEnchantment(enchantment);
        }
        return enchantRandomlyFunctionBuilder.build();
    }

    public static LootItemFunction enchantWithLevels(NumberProvider numberProvider) {
        return LootFunction.enchantWithLevels(numberProvider, true);
    }

    public static LootItemFunction enchantWithLevels(NumberProvider numberProvider, boolean allowTreasure) {
        EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.enchantWithLevels((NumberProvider)numberProvider);
        if (allowTreasure) {
            builder.allowTreasure();
        }
        return builder.build();
    }

    public static LootItemFunction applyLootingBonus(NumberProvider numberProvider) {
        LootingEnchantFunction.Builder lootingEnchantBuilder = LootingEnchantFunction.lootingMultiplier((NumberProvider)numberProvider);
        return lootingEnchantBuilder.build();
    }

    public static LootItemFunction applyBinomialDistributionBonus(Enchantment enchantment, float probability, int extra) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.addBonusBinomialDistributionCount((Enchantment)enchantment, (float)probability, (int)extra);
        return applyBonusBuilder.build();
    }

    public static LootItemFunction applyOreBonus(Enchantment enchantment) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.addOreBonusCount((Enchantment)enchantment);
        return applyBonusBuilder.build();
    }

    public static LootItemFunction applyBonus(Enchantment enchantment, int multiplier) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.addUniformBonusCount((Enchantment)enchantment, (int)multiplier);
        return applyBonusBuilder.build();
    }

    public static LootItemFunction simulateExplosionDecay() {
        return ApplyExplosionDecay.explosionDecay().build();
    }

    public static LootItemFunction smelt() {
        return SmeltItemFunction.smelted().build();
    }

    public static LootItemFunction damage(NumberProvider numberProvider) {
        return SetItemDamageFunction.setDamage((NumberProvider)numberProvider).build();
    }

    public static LootItemFunction addPotion(Potion potion) {
        Objects.requireNonNull(potion);
        return SetPotionFunction.setPotion((Potion)potion).build();
    }

    public static LootItemFunction addAttributes(Consumer<AddAttributesFunction.Builder> action) {
        AddAttributesFunction.Builder builder = new AddAttributesFunction.Builder();
        action.accept(builder);
        return builder.build();
    }

    public static LootItemFunction limitCount(@Nullable NumberProvider numberProviderMin, @Nullable NumberProvider numberProviderMax) {
        IntRange intRange = new IntRange(numberProviderMin, numberProviderMax);
        return LimitCount.limitCount((IntRange)intRange).build();
    }

    public static LootItemFunction setCount(NumberProvider numberProvider) {
        return SetItemCountFunction.setCount((NumberProvider)numberProvider).build();
    }

    public static LootItemFunction addLore(Component ... components) {
        SetLoreFunction.Builder builder = SetLoreFunction.setLore();
        for (Component c : components) {
            builder.addLine(c);
        }
        return builder.build();
    }

    public static LootItemFunction replaceLore(Component ... components) {
        SetLoreFunction.Builder builder = SetLoreFunction.setLore();
        for (Component c : components) {
            builder.addLine(c);
        }
        return builder.setReplace(true).build();
    }

    public static LootItemFunction setName(Component component) {
        return SetNameFunction.setName((Component)component).build();
    }

    public static LootItemFunction setNBT(CompoundTag tag) {
        return SetNbtFunction.setTag((CompoundTag)tag).build();
    }

    public static LootItemFunction setNbt(CompoundTag tag) {
        return SetNbtFunction.setTag((CompoundTag)tag).build();
    }

    public static LootItemFunction fromJson(JsonObject json) {
        return (LootItemFunction)LootItemFunctions.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)LootJS.LOG).error(arg_0));
    }
}

