/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.core.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.loot.LootFunctionsContainer;
import com.almostreliable.lootjs.util.DebugInfo;
import com.almostreliable.lootjs.util.ListHolder;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public class LootFunctionList
extends ListHolder<LootItemFunction, LootItemFunction>
implements LootFunctionsContainer<LootFunctionList>,
BiFunction<ItemStack, LootContext, ItemStack> {
    public LootFunctionList() {
    }

    public LootFunctionList(List<LootItemFunction> functions) {
        super(functions);
    }

    @Override
    public Iterator<LootItemFunction> iterator() {
        return this.elements.listIterator();
    }

    @Override
    protected LootItemFunction wrap(LootItemFunction entry) {
        return entry;
    }

    @Override
    protected LootItemFunction unwrap(LootItemFunction entry) {
        return entry;
    }

    @Override
    public LootFunctionList addFunction(LootItemFunction function) {
        this.add(function);
        return this;
    }

    public void collectDebugInfo(DebugInfo info) {
        if (this.isEmpty()) {
            return;
        }
        info.add("% Functions: [");
        info.push();
        for (LootItemFunction entry : this) {
            ResourceLocation key = BuiltInRegistries.LOOT_FUNCTION_TYPE.getKey((Object)entry.getType());
            if (key == null) {
                info.add(entry.getClass().getSimpleName());
                continue;
            }
            info.add(key.toString());
        }
        info.pop();
        info.add("]");
    }

    @Override
    public ItemStack apply(ItemStack itemStack, LootContext context) {
        for (LootItemFunction entry : this) {
            itemStack = (ItemStack)entry.apply((Object)itemStack, (Object)context);
        }
        return itemStack;
    }

    public void replace(LootItemFunctionType type, LootItemFunction function) {
        this.elements.replaceAll(entry -> entry.getType().equals((Object)type) ? function : entry);
    }

    public boolean remove(ResourceLocationFilter type) {
        return this.elements.removeIf(element -> type.test(BuiltInRegistries.LOOT_FUNCTION_TYPE.getKey((Object)element.getType())));
    }

    public boolean contains(LootItemFunctionType type) {
        return this.indexOf(type) != -1;
    }

    public int indexOf(LootItemFunctionType type) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((LootItemFunction)this.elements.get(i)).getType().equals((Object)type)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(LootItemFunctionType type) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (!((LootItemFunction)this.elements.get(i)).getType().equals((Object)type)) continue;
            return i;
        }
        return -1;
    }
}

