/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.loot.AddAttributesFunction;
import com.almostreliable.lootjs.loot.LootFunction;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootFunctionsContainer<F extends LootFunctionsContainer<?>> {
    default public F enchantRandomly() {
        return this.enchantRandomly(new Enchantment[0]);
    }

    default public F enchantRandomly(Enchantment[] enchantments) {
        return this.addFunction(LootFunction.enchantRandomly(enchantments));
    }

    default public F enchantWithLevels(NumberProvider numberProvider) {
        return this.addFunction(LootFunction.enchantWithLevels(numberProvider));
    }

    default public F enchantWithLevels(NumberProvider numberProvider, boolean allowTreasure) {
        return this.addFunction(LootFunction.enchantWithLevels(numberProvider, allowTreasure));
    }

    default public F applyLootingBonus(NumberProvider numberProvider) {
        return this.addFunction(LootFunction.applyLootingBonus(numberProvider));
    }

    default public F applyBinomialDistributionBonus(Enchantment enchantment, float probability, int extra) {
        return this.addFunction(LootFunction.applyBinomialDistributionBonus(enchantment, probability, extra));
    }

    default public F applyOreBonus(Enchantment enchantment) {
        return this.addFunction(LootFunction.applyOreBonus(enchantment));
    }

    default public F applyBonus(Enchantment enchantment, int multiplier) {
        return this.addFunction(LootFunction.applyBonus(enchantment, multiplier));
    }

    default public F simulateExplosionDecay() {
        return this.addFunction(LootFunction.simulateExplosionDecay());
    }

    default public F smelt() {
        return this.addFunction(LootFunction.smelt());
    }

    default public F damage(NumberProvider numberProvider) {
        return this.addFunction(LootFunction.damage(numberProvider));
    }

    default public F addPotion(Potion potion) {
        return this.addFunction(LootFunction.addPotion(potion));
    }

    default public F addAttributes(Consumer<AddAttributesFunction.Builder> action) {
        return this.addFunction(LootFunction.addAttributes(action));
    }

    default public F limitCount(@Nullable NumberProvider numberProviderMin, @Nullable NumberProvider numberProviderMax) {
        return this.addFunction(LootFunction.limitCount(numberProviderMin, numberProviderMax));
    }

    default public F setCount(NumberProvider numberProvider) {
        return this.addFunction(LootFunction.setCount(numberProvider));
    }

    default public F addLore(Component ... components) {
        return this.addFunction(LootFunction.addLore(components));
    }

    default public F replaceLore(Component ... components) {
        return this.addFunction(LootFunction.replaceLore(components));
    }

    default public F setName(Component component) {
        return this.addFunction(LootFunction.setName(component));
    }

    default public F setNBT(CompoundTag tag) {
        return this.addFunction(LootFunction.setNBT(tag));
    }

    default public F setNbt(CompoundTag tag) {
        return this.addFunction(LootFunction.setNbt(tag));
    }

    default public F jsonFunction(JsonObject json) {
        return this.addFunction(LootFunction.fromJson(json));
    }

    public F addFunction(LootItemFunction var1);
}

