/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.core.ItemStackFactory;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.entry.SingleLootEntry;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.loot.modifier.CancelableLootAction;
import com.almostreliable.lootjs.loot.modifier.GroupedLootHandler;
import com.almostreliable.lootjs.loot.modifier.LootHandler;
import com.almostreliable.lootjs.loot.modifier.handler.AddLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.ContainsLootCheck;
import com.almostreliable.lootjs.loot.modifier.handler.CustomPlayerAction;
import com.almostreliable.lootjs.loot.modifier.handler.DropExperienceAction;
import com.almostreliable.lootjs.loot.modifier.handler.ExplodeAction;
import com.almostreliable.lootjs.loot.modifier.handler.LightningStrikeAction;
import com.almostreliable.lootjs.loot.modifier.handler.ModifyLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.RemoveLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.ReplaceLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.WeightedAddLootAction;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootHandlerContainer<A extends LootHandlerContainer<?>> {
    default public A addLoot(LootEntry ... entries) {
        return this.addHandler(new AddLootAction(entries));
    }

    default public A addAlternativesLoot(LootEntry ... entries) {
        return this.addHandler(new AddLootAction(LootEntry.alternative(entries)));
    }

    default public A addSequenceLoot(LootEntry ... entries) {
        return this.addHandler(new AddLootAction(LootEntry.sequence(entries)));
    }

    default public A addWeightedLoot(NumberProvider numberProvider, boolean allowDuplicateLoot, SingleLootEntry[] poolEntries) {
        SimpleWeightedRandomList.Builder weightedListBuilder = SimpleWeightedRandomList.builder();
        for (SingleLootEntry poolEntry : poolEntries) {
            weightedListBuilder.add((Object)poolEntry, poolEntry.getWeight());
        }
        return this.addHandler(new WeightedAddLootAction(numberProvider, (SimpleWeightedRandomList<SingleLootEntry>)weightedListBuilder.build(), allowDuplicateLoot));
    }

    default public A addWeightedLoot(NumberProvider numberProvider, SingleLootEntry[] poolEntries) {
        return this.addWeightedLoot(numberProvider, true, poolEntries);
    }

    default public A addWeightedLoot(SingleLootEntry[] poolEntries) {
        return this.addWeightedLoot((NumberProvider)ConstantValue.exactly((float)1.0f), true, poolEntries);
    }

    default public A removeLoot(ItemFilter filter) {
        return this.addHandler(new RemoveLootAction(filter));
    }

    default public A replaceLoot(ItemFilter filter, ItemStackFactory itemStackFactory) {
        return this.replaceLoot(filter, itemStackFactory, false);
    }

    default public A replaceLoot(ItemFilter filter, ItemStackFactory itemStackFactory, boolean preserveCount) {
        return this.addHandler(new ReplaceLootAction(filter, itemStackFactory, preserveCount));
    }

    default public A modifyLoot(ItemFilter filter, ModifyLootAction.Callback callback) {
        return this.addHandler(new ModifyLootAction(filter, callback));
    }

    default public A triggerExplosion(float radius, boolean destroy, boolean fire) {
        Explosion.BlockInteraction mode = destroy ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        return this.addHandler(new ExplodeAction(radius, mode, fire));
    }

    default public A triggerExplosion(float radius, Explosion.BlockInteraction mode, boolean fire) {
        return this.addHandler(new ExplodeAction(radius, mode, fire));
    }

    default public A triggerLightningStrike(boolean shouldDamage) {
        return this.addHandler(new LightningStrikeAction(shouldDamage));
    }

    default public A dropExperience(int amount) {
        return this.addHandler(new DropExperienceAction(amount));
    }

    default public A customAction(CancelableLootAction action) {
        return this.addHandler(CancelableLootAction.asHandler(action));
    }

    default public A playerAction(Consumer<ServerPlayer> action) {
        return this.addHandler(new CustomPlayerAction(action));
    }

    default public A group(ItemFilter filter, Consumer<GroupedLootHandler.Builder> callback) {
        GroupedLootHandler.Builder builder = new GroupedLootHandler.Builder(filter);
        callback.accept(builder);
        return this.addHandler(builder.build());
    }

    default public A group(Consumer<GroupedLootHandler.Builder> callback) {
        GroupedLootHandler.Builder builder = new GroupedLootHandler.Builder();
        callback.accept(builder);
        return this.addHandler(builder.build());
    }

    default public A matchLoot(ItemFilter filter) {
        return this.matchLoot(filter, false);
    }

    default public A matchLoot(ItemFilter filter, boolean exact) {
        return this.addHandler(new ContainsLootCheck(filter, exact));
    }

    public A addHandler(LootHandler var1);
}

