/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.loot.condition.builder.DistancePredicateBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public interface Predicates {
    public static ItemPredicate.Builder item(Item ... items) {
        return ItemPredicate.Builder.item().of((ItemLike[])items);
    }

    public static ItemPredicate.Builder itemTag(String tag) {
        return ItemPredicate.Builder.item().of(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(tag)));
    }

    public static EntityPredicate.Builder entity(EntityTypePredicate predicates) {
        return EntityPredicate.Builder.entity().entityType(predicates);
    }

    public static EntityPredicate.Builder entity() {
        return EntityPredicate.Builder.entity();
    }

    public static EntityEquipmentPredicate.Builder equipment() {
        return EntityEquipmentPredicate.Builder.equipment();
    }

    public static LocationPredicate.Builder location() {
        return LocationPredicate.Builder.location();
    }

    public static DistancePredicateBuilder distance() {
        return new DistancePredicateBuilder();
    }

    public static BlockPredicate.Builder block(Block ... blocks) {
        return BlockPredicate.Builder.block().of(blocks);
    }

    public static BlockPredicate.Builder blockTag(String tag) {
        return BlockPredicate.Builder.block().of(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation(tag)));
    }

    public static FluidPredicate.Builder fluid(Fluid fluid) {
        return FluidPredicate.Builder.fluid().of(fluid);
    }

    public static FluidPredicate.Builder fluidTag(String tag) {
        return FluidPredicate.Builder.fluid().of(TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)new ResourceLocation(tag)));
    }

    public static DamageSourcePredicate.Builder damageSource() {
        return DamageSourcePredicate.Builder.damageType();
    }

    public static LightPredicate light(int min, int max) {
        return LightPredicate.Builder.light().setComposite(MinMaxBounds.Ints.between((int)min, (int)max)).build();
    }

    public static EnchantmentPredicate enchantment(Enchantment enchantment) {
        return new EnchantmentPredicate(enchantment, MinMaxBounds.Ints.ANY);
    }

    public static EnchantmentPredicate enchantment(@Nullable Enchantment enchantment, MinMaxBounds.Ints levels) {
        return new EnchantmentPredicate(enchantment == null ? Optional.empty() : Optional.of(enchantment.builtInRegistryHolder()), levels);
    }

    public static NbtPredicate nbt(CompoundTag nbt) {
        return new NbtPredicate(nbt);
    }
}

