/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.condition;

import com.almostreliable.lootjs.loot.condition.IExtendedLootCondition;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class BiomeCheck
implements IExtendedLootCondition {
    protected final List<ResourceKey<Biome>> biomes;
    protected final List<TagKey<Biome>> tags;

    public BiomeCheck(List<ResourceKey<Biome>> biomes, List<TagKey<Biome>> tags) {
        this.biomes = biomes;
        this.tags = tags;
    }

    public boolean test(LootContext context) {
        Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        if (origin == null) {
            return false;
        }
        BlockPos blockPos = new BlockPos((int)origin.x, (int)origin.y, (int)origin.z);
        return this.match((Holder<Biome>)context.getLevel().getBiome(blockPos));
    }

    protected boolean match(Holder<Biome> biomeHolder) {
        for (ResourceKey<Biome> resourceKey : this.biomes) {
            if (biomeHolder.is(resourceKey)) continue;
            return false;
        }
        for (TagKey tagKey : this.tags) {
            if (biomeHolder.is(tagKey)) continue;
            return false;
        }
        return true;
    }

    public List<ResourceKey<Biome>> getBiomes() {
        return Collections.unmodifiableList(this.biomes);
    }

    public List<TagKey<Biome>> getTags() {
        return Collections.unmodifiableList(this.tags);
    }
}

