/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.extension;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.util.LootContextUtils;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

@RemapPrefixForJS(value="lootjs$")
public interface LootContextExtension {
    public static LootContextExtension cast(LootContext context) {
        return (LootContextExtension)context;
    }

    public LootContext lootjs$self();

    default public boolean lootjs$isType(LootType type) {
        return type == this.lootjs$getType();
    }

    public LootType lootjs$getType();

    default public Vec3 lootjs$getPosition() {
        Vec3 pos = (Vec3)this.lootjs$self().getParamOrNull(LootContextParams.ORIGIN);
        if (pos != null) {
            return pos;
        }
        Entity entity = this.lootjs$getEntity();
        if (entity != null) {
            return entity.position();
        }
        LootJS.LOG.warn("Loot table {} has no position. This should not happen", (Object)this.lootjs$self().getQueriedLootTableId());
        return Vec3.ZERO;
    }

    @Nullable
    default public Entity lootjs$getEntity() {
        return (Entity)this.lootjs$self().getParamOrNull(LootContextParams.THIS_ENTITY);
    }

    @Nullable
    default public Entity lootjs$getKillerEntity() {
        return (Entity)this.lootjs$self().getParamOrNull(LootContextParams.KILLER_ENTITY);
    }

    @Nullable
    default public ServerPlayer lootjs$getKillerPlayer() {
        return LootContextUtils.getPlayerOrNull(this.lootjs$self());
    }

    @Nullable
    default public DamageSource lootjs$getDamageSource() {
        return (DamageSource)this.lootjs$self().getParamOrNull(LootContextParams.DAMAGE_SOURCE);
    }

    default public ItemStack lootjs$getTool() {
        ItemStack tool = (ItemStack)this.lootjs$self().getParamOrNull(LootContextParams.TOOL);
        if (tool != null) {
            return tool;
        }
        return ItemStack.EMPTY;
    }

    default public boolean lootjs$isExploded() {
        return this.lootjs$self().hasParam(LootContextParams.EXPLOSION_RADIUS);
    }

    default public float lootjs$getExplosionRadius() {
        Float f = (Float)this.lootjs$self().getParamOrNull(LootContextParams.EXPLOSION_RADIUS);
        return f != null ? f.floatValue() : 0.0f;
    }

    @Nullable
    default public MinecraftServer lootjs$getServer() {
        return this.lootjs$self().getLevel().getServer();
    }

    default public int lootjs$getLooting() {
        Entity killer = (Entity)this.lootjs$self().getParamOrNull(LootContextParams.KILLER_ENTITY);
        if (killer instanceof LivingEntity) {
            LivingEntity asLiving = (LivingEntity)killer;
            return EnchantmentHelper.getMobLooting((LivingEntity)asLiving);
        }
        return 0;
    }

    public Map<String, Object> lootjs$getData();
}

