/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.modifier;

import com.almostreliable.lootjs.core.LootBucket;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.loot.LootConditionsContainer;
import com.almostreliable.lootjs.loot.LootFunctionsContainer;
import com.almostreliable.lootjs.loot.LootHandlerContainer;
import com.almostreliable.lootjs.loot.modifier.LootHandler;
import com.almostreliable.lootjs.loot.modifier.handler.VanillaConditionWrapper;
import com.almostreliable.lootjs.loot.modifier.handler.VanillaFunctionWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class GroupedLootHandler
implements LootHandler {
    private final LootHandler[] handlers;
    private final NumberProvider repeat;

    public GroupedLootHandler(NumberProvider repeat, Collection<LootHandler> handlers) {
        this.repeat = repeat;
        this.handlers = (LootHandler[])handlers.toArray(LootHandler[]::new);
    }

    @Override
    public boolean apply(LootContext context, LootBucket loot) {
        int r = this.repeat.getInt(context);
        for (int i = 0; i < r; ++i) {
            for (LootHandler handler : this.handlers) {
                if (handler.apply(context, loot)) continue;
                return false;
            }
        }
        return true;
    }

    public static class Builder
    implements LootConditionsContainer<Builder>,
    LootFunctionsContainer<Builder>,
    LootHandlerContainer<Builder> {
        private final List<LootHandler> handlers = new ArrayList<LootHandler>();
        private NumberProvider repeat = ConstantValue.exactly((float)1.0f);
        @Nullable
        private final ItemFilter lootItemsFilter;

        public Builder(ItemFilter lootItemsFilter) {
            this.lootItemsFilter = lootItemsFilter;
        }

        public Builder() {
            this.lootItemsFilter = null;
        }

        public Builder repeat(NumberProvider repeat) {
            this.repeat = repeat;
            return this;
        }

        @Override
        public Builder addCondition(LootItemCondition condition) {
            this.handlers.add(new VanillaConditionWrapper(condition));
            return this;
        }

        @Override
        public Builder addHandler(LootHandler action) {
            this.handlers.add(action);
            return this;
        }

        @Override
        public Builder addFunction(LootItemFunction lootItemFunction) {
            return this.addHandler(new VanillaFunctionWrapper(lootItemFunction));
        }

        public GroupedLootHandler build() {
            if (this.lootItemsFilter != null) {
                return new Filtered(this.repeat, this.handlers, this.lootItemsFilter);
            }
            return new GroupedLootHandler(this.repeat, this.handlers);
        }
    }

    public static class Filtered
    extends GroupedLootHandler {
        private final ItemFilter lootItemsFilter;

        public Filtered(NumberProvider repeat, Collection<LootHandler> handlers, ItemFilter lootItemsFilter) {
            super(repeat, handlers);
            this.lootItemsFilter = lootItemsFilter;
        }

        @Override
        public boolean apply(LootContext context, LootBucket loot) {
            LootBucket filteredLoot = loot.extract(this.lootItemsFilter);
            boolean result = super.apply(context, filteredLoot);
            loot.merge(filteredLoot);
            return result;
        }
    }
}

