/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.modifier;

import com.almostreliable.lootjs.core.LootBucket;
import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.loot.LootConditionsContainer;
import com.almostreliable.lootjs.loot.LootFunctionsContainer;
import com.almostreliable.lootjs.loot.LootHandlerContainer;
import com.almostreliable.lootjs.loot.extension.LootContextExtension;
import com.almostreliable.lootjs.loot.modifier.LootHandler;
import com.almostreliable.lootjs.loot.modifier.handler.VanillaConditionWrapper;
import com.almostreliable.lootjs.loot.modifier.handler.VanillaFunctionWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootModifier {
    private final Predicate<LootContext> shouldRun;
    private final LootHandler[] handlers;
    private final String name;

    public LootModifier(Predicate<LootContext> shouldRun, Collection<LootHandler> handlers, String name) {
        this.shouldRun = shouldRun;
        this.handlers = (LootHandler[])handlers.toArray(LootHandler[]::new);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void run(LootContext context, LootBucket loot) {
        if (!this.shouldRun.test(context)) {
            return;
        }
        for (LootHandler handler : this.handlers) {
            if (handler.apply(context, loot)) continue;
            return;
        }
    }

    public record TypeFiltered(LootType[] types) implements Predicate<LootContext>
    {
        @Override
        public boolean test(LootContext context) {
            LootContextExtension extension = LootContextExtension.cast(context);
            for (LootType type : this.types) {
                if (!extension.lootjs$isType(type)) continue;
                return true;
            }
            return false;
        }
    }

    public record EntityFiltered(Set<EntityType<?>> entities) implements Predicate<LootContext>
    {
        @Override
        public boolean test(LootContext context) {
            Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
            return entity != null && this.entities.contains(entity.getType()) && LootContextExtension.cast(context).lootjs$isType(LootType.ENTITY);
        }
    }

    public record BlockFiltered(Predicate<BlockState> predicate) implements Predicate<LootContext>
    {
        @Override
        public boolean test(LootContext context) {
            BlockState blockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
            return blockState != null && this.predicate.test(blockState) && LootContextExtension.cast(context).lootjs$isType(LootType.BLOCK);
        }
    }

    public record TableFiltered(ResourceLocationFilter[] filters) implements Predicate<LootContext>
    {
        @Override
        public boolean test(LootContext context) {
            for (ResourceLocationFilter filter : this.filters) {
                if (!filter.test(context.getQueriedLootTableId())) continue;
                return true;
            }
            return false;
        }
    }

    public static class Builder
    implements LootConditionsContainer<Builder>,
    LootFunctionsContainer<Builder>,
    LootHandlerContainer<Builder> {
        private final List<LootHandler> handlers = new ArrayList<LootHandler>();
        private final Predicate<LootContext> shouldRun;
        private String name;

        public Builder(Predicate<LootContext> shouldRun, String name) {
            this.shouldRun = shouldRun;
            this.name = name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder addCondition(LootItemCondition condition) {
            this.handlers.add(new VanillaConditionWrapper(condition));
            return this;
        }

        @Override
        public Builder addHandler(LootHandler action) {
            this.handlers.add(action);
            return this;
        }

        @Override
        public Builder addFunction(LootItemFunction lootItemFunction) {
            return this.addHandler(new VanillaFunctionWrapper(lootItemFunction));
        }

        public LootModifier build() {
            return new LootModifier(this.shouldRun, this.handlers, this.name);
        }
    }
}

