/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.modifier.handler;

import com.almostreliable.lootjs.core.LootBucket;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.loot.modifier.LootHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class ContainsLootCheck
implements LootHandler {
    private final ItemFilter itemFilter;
    private final boolean exact;

    public ContainsLootCheck(ItemFilter itemFilter, boolean exact) {
        this.itemFilter = itemFilter;
        this.exact = exact;
    }

    @Override
    public boolean apply(LootContext context, LootBucket loot) {
        return this.exact ? this.matchExact(loot) : this.match(loot);
    }

    private boolean match(LootBucket loot) {
        for (ItemStack itemStack : loot) {
            if (!this.itemFilter.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    private boolean matchExact(LootBucket loot) {
        for (ItemStack itemStack : loot) {
            if (this.itemFilter.test(itemStack)) continue;
            return false;
        }
        return true;
    }
}

