/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.modifier.handler;

import com.almostreliable.lootjs.core.LootBucket;
import com.almostreliable.lootjs.core.entry.SingleLootEntry;
import com.almostreliable.lootjs.loot.modifier.LootHandler;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class WeightedAddLootAction
implements LootHandler {
    private final NumberProvider numberProvider;
    private final SimpleWeightedRandomList<SingleLootEntry> weightedRandomList;
    private final boolean allowDuplicateLoot;

    public WeightedAddLootAction(NumberProvider numberProvider, SimpleWeightedRandomList<SingleLootEntry> weightedRandomList, boolean allowDuplicateLoot) {
        this.numberProvider = numberProvider;
        this.weightedRandomList = weightedRandomList;
        this.allowDuplicateLoot = allowDuplicateLoot;
        if (weightedRandomList.isEmpty()) {
            throw new IllegalArgumentException("Weighted list must have at least one item");
        }
    }

    @Override
    public boolean apply(LootContext context, LootBucket loot) {
        RandomSource random = context.getLevel().getRandom();
        AbstractCollection rolledItems = this.allowDuplicateLoot ? new ArrayList() : new HashSet();
        int lootRolls = this.numberProvider.getInt(context);
        for (int i = 0; i < lootRolls; ++i) {
            this.weightedRandomList.getRandomValue(random).ifPresent(poolEntry -> {
                ItemStack item = poolEntry.create(context);
                if (item != null) {
                    rolledItems.add(item);
                }
            });
        }
        loot.addAllItems(rolledItems.stream().map(ItemStack::copy).toList());
        return true;
    }
}

