/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.table;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.entry.DynamicLootEntry;
import com.almostreliable.lootjs.core.entry.ItemLootEntry;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.entry.SimpleLootEntry;
import com.almostreliable.lootjs.core.entry.TableReferenceLootEntry;
import com.almostreliable.lootjs.core.entry.TagLootEntry;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.core.filters.ResourceLocationFilter;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import org.apache.logging.log4j.Logger;

public interface LootApplier {
    default public LootApplier addCustomEntry(JsonObject json) {
        LootPoolEntryContainer vanilla = (LootPoolEntryContainer)LootPoolEntries.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)LootJS.LOG).error(arg_0));
        return this.addEntry(LootEntry.ofVanilla(vanilla));
    }

    default public LootApplier addItem(ItemStack itemStack) {
        return this.addEntry(LootEntry.of(itemStack));
    }

    public LootApplier addEntry(LootEntry var1);

    public LootApplier transformEntry(UnaryOperator<SimpleLootEntry> var1, boolean var2);

    default public LootApplier transformEntry(UnaryOperator<SimpleLootEntry> onTransform) {
        this.transformEntry(onTransform, true);
        return this;
    }

    public LootApplier removeEntry(Predicate<SimpleLootEntry> var1, boolean var2);

    default public LootApplier removeEntry(Predicate<SimpleLootEntry> onRemove) {
        this.removeEntry(onRemove, true);
        return this;
    }

    default public LootApplier removeItem(ItemFilter filter) {
        this.removeItem(filter, true);
        return this;
    }

    default public LootApplier removeItem(ItemFilter filter, boolean deepRemove) {
        this.removeEntry(entry -> {
            ItemLootEntry ile;
            return entry instanceof ItemLootEntry && (ile = (ItemLootEntry)entry).test(filter);
        }, deepRemove);
        return this;
    }

    default public LootApplier removeTag(String tag) {
        this.removeTag(tag, true);
        return this;
    }

    default public LootApplier removeTag(String tag, boolean deepRemove) {
        this.removeEntry(entry -> {
            TagLootEntry tle;
            return entry instanceof TagLootEntry && (tle = (TagLootEntry)entry).isTag(tag);
        }, deepRemove);
        return this;
    }

    default public LootApplier removeReference(ResourceLocationFilter filter) {
        this.removeReference(filter, true);
        return this;
    }

    default public LootApplier removeReference(ResourceLocationFilter filter, boolean deepRemove) {
        this.removeEntry(entry -> {
            TableReferenceLootEntry d;
            return entry instanceof TableReferenceLootEntry && filter.test((d = (TableReferenceLootEntry)entry).getLocation());
        }, deepRemove);
        return this;
    }

    default public LootApplier removeDynamic(ResourceLocationFilter filter) {
        this.removeDynamic(filter, true);
        return this;
    }

    default public LootApplier removeDynamic(ResourceLocationFilter filter, boolean deepRemove) {
        this.removeEntry(entry -> {
            DynamicLootEntry d;
            return entry instanceof DynamicLootEntry && filter.test((d = (DynamicLootEntry)entry).getLocation());
        }, deepRemove);
        return this;
    }

    default public LootApplier replaceItem(ItemFilter filter, ItemStack item) {
        this.replaceItem(filter, item, true);
        return this;
    }

    default public LootApplier replaceItem(ItemFilter filter, ItemStack item, boolean deepReplace) {
        this.transformEntry(entry -> {
            ItemLootEntry ile;
            if (entry instanceof ItemLootEntry && (ile = (ItemLootEntry)entry).test(filter)) {
                return new ItemLootEntry(item);
            }
            return entry;
        }, deepReplace);
        return this;
    }
}

