/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.table;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.entry.SimpleLootEntry;
import com.almostreliable.lootjs.loot.LootConditionList;
import com.almostreliable.lootjs.loot.LootEntryList;
import com.almostreliable.lootjs.loot.LootFunctionList;
import com.almostreliable.lootjs.loot.extension.LootPoolExtension;
import com.almostreliable.lootjs.loot.table.LootApplier;
import com.almostreliable.lootjs.util.DebugInfo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.Logger;

public class MutableLootPool
implements LootApplier {
    @Nullable
    private LootConditionList conditions;
    @Nullable
    private LootFunctionList functions;
    @Nullable
    private LootEntryList entries;
    private final LootPool vanillaPool;

    public MutableLootPool(LootPool pool) {
        this.vanillaPool = pool;
    }

    public MutableLootPool() {
        this.vanillaPool = new LootPool(new ArrayList(), new ArrayList(), new ArrayList(), (NumberProvider)ConstantValue.exactly((float)1.0f), (NumberProvider)ConstantValue.exactly((float)0.0f), Optional.empty());
    }

    public MutableLootPool rolls(NumberProvider rolls) {
        LootPoolExtension.cast(this.vanillaPool).lootjs$setRolls(rolls);
        return this;
    }

    public MutableLootPool bonusRolls(NumberProvider bonusRolls) {
        LootPoolExtension.cast(this.vanillaPool).lootjs$setBonusRolls(bonusRolls);
        return this;
    }

    public LootConditionList getConditions() {
        if (this.conditions == null) {
            this.conditions = LootPoolExtension.cast(this.vanillaPool).lootjs$createConditionList();
        }
        return this.conditions;
    }

    public LootFunctionList getFunctions() {
        if (this.functions == null) {
            this.functions = LootPoolExtension.cast(this.vanillaPool).lootjs$createFunctionList();
        }
        return this.functions;
    }

    public LootEntryList getEntries() {
        if (this.entries == null) {
            this.entries = LootPoolExtension.cast(this.vanillaPool).lootjs$createEntryList();
        }
        return this.entries;
    }

    public LootPool getVanillaPool() {
        return this.vanillaPool;
    }

    public void collectDebugInfo(DebugInfo info) {
        info.add("% Rolls -> " + this.getRollStr(LootPoolExtension.cast(this.vanillaPool).lootjs$getRolls()));
        info.add("% Bonus rolls -> " + this.getRollStr(LootPoolExtension.cast(this.vanillaPool).lootjs$getBonusRolls()));
        this.getEntries().collectDebugInfo(info);
        this.getConditions().collectDebugInfo(info);
        this.getFunctions().collectDebugInfo(info);
    }

    private String getRollStr(NumberProvider numberProvider) {
        JsonElement tree = (JsonElement)NumberProviders.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)numberProvider).getOrThrow(false, arg_0 -> ((Logger)LootJS.LOG).error(arg_0));
        if (numberProvider instanceof ConstantValue) {
            if (tree instanceof JsonObject) {
                JsonObject json = (JsonObject)tree;
                return json.get("value").getAsString();
            }
            return tree.getAsString();
        }
        if (numberProvider instanceof UniformGenerator) {
            if (tree instanceof JsonObject) {
                JsonObject json = (JsonObject)tree;
                return "[" + json.get("min").getAsString() + " -> " + json.get("max").getAsString() + "]";
            }
            return tree.getAsString();
        }
        return tree.toString();
    }

    @Override
    public MutableLootPool addEntry(LootEntry entry) {
        this.getEntries().add(entry);
        return this;
    }

    @Override
    public MutableLootPool transformEntry(UnaryOperator<SimpleLootEntry> onTransform, boolean deepTransform) {
        this.getEntries().transformEntry((UnaryOperator)onTransform, deepTransform);
        return this;
    }

    @Override
    public MutableLootPool removeEntry(Predicate<SimpleLootEntry> onRemove, boolean deepRemove) {
        this.getEntries().removeEntry((Predicate)onRemove, deepRemove);
        return this;
    }

    public MutableLootPool when(Consumer<LootConditionList> onConditions) {
        onConditions.accept(this.getConditions());
        return this;
    }

    public MutableLootPool apply(Consumer<LootFunctionList> onModifiers) {
        onModifiers.accept(this.getFunctions());
        return this;
    }
}

