/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.table;

import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.entry.SimpleLootEntry;
import com.almostreliable.lootjs.loot.LootFunctionList;
import com.almostreliable.lootjs.loot.extension.LootTableExtension;
import com.almostreliable.lootjs.loot.table.LootApplier;
import com.almostreliable.lootjs.loot.table.MutableLootPool;
import com.almostreliable.lootjs.loot.table.PostLootAction;
import com.almostreliable.lootjs.loot.table.PostLootActionOwner;
import com.almostreliable.lootjs.util.DebugInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class MutableLootTable
implements LootApplier {
    private final LootTable origin;
    private final ResourceLocation location;
    @Nullable
    private List<MutableLootPool> pools;
    @Nullable
    private LootFunctionList functions;
    private boolean potentialModified;

    public MutableLootTable(LootTable lootTable) {
        this(lootTable, lootTable.getLootTableId());
    }

    public MutableLootTable(LootTable lootTable, ResourceLocation location) {
        this.location = location;
        this.origin = lootTable;
    }

    public MutableLootTable(LootContextParamSet paramSet, ResourceLocation location) {
        this(new LootTable.Builder().setParamSet(paramSet).setRandomSequence(location).build(), location);
    }

    public ResourceLocation getRandomSequence() {
        ResourceLocation rs = LootTableExtension.cast(this.origin).lootjs$getRandomSequence();
        return rs == null ? this.getLocation() : rs;
    }

    public void setRandomSequence(@Nullable ResourceLocation randomSequence) {
        LootTableExtension.cast(this.origin).lootjs$setRandomSequence(randomSequence);
    }

    public LootType getLootType() {
        return LootType.getLootType(this.origin.getParamSet());
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public List<MutableLootPool> getPools() {
        if (this.pools == null) {
            this.markDirty();
            this.pools = new ArrayList<MutableLootPool>();
            for (LootPool pool : ((LootTableExtension)this.origin).lootjs$getPools()) {
                this.pools.add(new MutableLootPool(pool));
            }
        }
        return this.pools;
    }

    public MutableLootTable firstPool(Consumer<MutableLootPool> onModifyPool) {
        onModifyPool.accept(this.firstPool());
        return this;
    }

    public MutableLootPool firstPool() {
        List<MutableLootPool> pools = this.getPools();
        if (pools.isEmpty()) {
            return this.createPool();
        }
        return pools.get(0);
    }

    public MutableLootTable createPool(Consumer<MutableLootPool> onCreatePool) {
        onCreatePool.accept(this.createPool());
        return this;
    }

    public MutableLootPool createPool() {
        MutableLootPool pool = new MutableLootPool();
        this.getPools().add(pool);
        return pool;
    }

    public LootFunctionList getFunctions() {
        if (this.functions == null) {
            this.markDirty();
            this.functions = LootTableExtension.cast(this.origin).lootjs$createFunctionList();
        }
        return this.functions;
    }

    public MutableLootTable onDrop(PostLootAction postLootAction) {
        LootTable lootTable = this.origin;
        if (lootTable instanceof PostLootActionOwner) {
            PostLootActionOwner owner = (PostLootActionOwner)lootTable;
            owner.lootjs$setPostLootAction(postLootAction);
        }
        return this;
    }

    public void writeToVanillaTable() {
        if (this.pools != null) {
            LootTableExtension.cast(this.origin).lootjs$setPools(this.getPools().stream().map(MutableLootPool::getVanillaPool).toList());
        }
    }

    public void print() {
        DebugInfo info = new DebugInfo();
        info.add("Loot table: " + this.location);
        info.push();
        info.add("% Pools [");
        info.push();
        List<MutableLootPool> pools = this.pools;
        if (pools == null) {
            List<LootPool> lootPools = LootTableExtension.cast(this.origin).lootjs$getPools();
            pools = lootPools.stream().map(MutableLootPool::new).toList();
        }
        for (MutableLootPool pool : pools) {
            info.add("{");
            info.push();
            pool.collectDebugInfo(info);
            info.pop();
            info.add("}");
        }
        info.pop();
        info.add("]");
        LootFunctionList f = this.functions == null ? LootTableExtension.cast(this.origin).lootjs$createFunctionList() : this.functions;
        f.collectDebugInfo(info);
        info.pop();
        info.release();
    }

    public MutableLootTable clear() {
        this.getFunctions().clear();
        this.getPools().clear();
        return this;
    }

    @Override
    public MutableLootTable addEntry(LootEntry entry) {
        this.createPool(pool -> pool.addEntry(entry));
        return this;
    }

    @Override
    public MutableLootTable transformEntry(UnaryOperator<SimpleLootEntry> onTransform, boolean deepTransform) {
        for (MutableLootPool pool : this.getPools()) {
            pool.transformEntry((UnaryOperator)onTransform, deepTransform);
        }
        return this;
    }

    @Override
    public MutableLootTable removeEntry(Predicate<SimpleLootEntry> onRemove, boolean deepRemove) {
        for (MutableLootPool pool : this.getPools()) {
            pool.removeEntry((Predicate)onRemove, deepRemove);
        }
        return this;
    }

    public MutableLootTable apply(Consumer<LootFunctionList> onModifiers) {
        onModifiers.accept(this.getFunctions());
        return this;
    }

    public boolean isDirty() {
        return this.potentialModified;
    }

    public void markDirty() {
        this.potentialModified = true;
    }
}

