/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;

public class ExtendedEntityFlagsPredicate {
    @Nullable
    protected final Boolean isInWater;
    @Nullable
    protected final Boolean isUnderWater;
    @Nullable
    protected final Boolean isMonster;
    @Nullable
    protected final Boolean isCreature;
    @Nullable
    protected final Boolean isOnGround;
    @Nullable
    protected final Boolean isUndeadMob;
    @Nullable
    protected final Boolean isArthropodMob;
    @Nullable
    protected final Boolean isIllegarMob;
    @Nullable
    protected final Boolean isWaterMob;

    public ExtendedEntityFlagsPredicate(@Nullable Boolean isOnFire, @Nullable Boolean isCrouching, @Nullable Boolean isSprinting, @Nullable Boolean isSwimming, @Nullable Boolean isBaby, @Nullable Boolean isInWater, @Nullable Boolean isUnderWater, @Nullable Boolean isMonster, @Nullable Boolean isCreature, @Nullable Boolean isOnGround, @Nullable Boolean isUndeadMob, @Nullable Boolean isArthropodMob, @Nullable Boolean isIllegarMob, @Nullable Boolean isWaterMob) {
        this.isInWater = isInWater;
        this.isUnderWater = isUnderWater;
        this.isMonster = isMonster;
        this.isCreature = isCreature;
        this.isOnGround = isOnGround;
        this.isUndeadMob = isUndeadMob;
        this.isArthropodMob = isArthropodMob;
        this.isIllegarMob = isIllegarMob;
        this.isWaterMob = isWaterMob;
    }

    public boolean matches(Entity entity) {
        return this.matchesInWater(entity) && this.matchesUnderWater(entity) && this.matchesMonster(entity) && this.matchesCreature(entity) && this.matchesOnGround(entity) && this.matchesMobTypes(entity);
    }

    private boolean matchesMobTypes(Entity entity) {
        return this.matchesMobType(this.isUndeadMob, entity, MobType.UNDEAD) && this.matchesMobType(this.isArthropodMob, entity, MobType.ARTHROPOD) && this.matchesMobType(this.isIllegarMob, entity, MobType.ILLAGER) && this.matchesMobType(this.isWaterMob, entity, MobType.WATER);
    }

    private boolean matchesMobType(@Nullable Boolean flag, Entity entity, MobType mobType) {
        if (flag == null) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            return flag == (((LivingEntity)entity).getMobType() == mobType);
        }
        return false;
    }

    private boolean matchesOnGround(Entity entity) {
        return this.isOnGround == null || this.isOnGround.booleanValue() == entity.onGround();
    }

    private boolean matchesCreature(Entity entity) {
        return this.isCreature == null || entity.getType().getCategory() == MobCategory.CREATURE == this.isCreature;
    }

    private boolean matchesMonster(Entity entity) {
        return this.isMonster == null || entity.getType().getCategory() == MobCategory.MONSTER == this.isMonster;
    }

    private boolean matchesUnderWater(Entity entity) {
        return this.isUnderWater == null || this.isUnderWater.booleanValue() == entity.isUnderWater();
    }

    private boolean matchesInWater(Entity entity) {
        return this.isInWater == null || this.isInWater.booleanValue() == entity.isInWater();
    }

    public JsonElement serializeToJson() {
        return new JsonObject();
    }

    private void addOptionalBoolean(JsonObject pJson, String pName, @Nullable Boolean pValue) {
        if (pValue != null) {
            pJson.addProperty(pName, pValue);
        }
    }
}

