/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.mixins;

import net.gigabit101.shrink.polylib.EntitySizeEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    private float eyeHeight;
    @Shadow
    protected boolean firstTick;
    @Shadow
    public boolean noPhysics;

    @Shadow
    protected abstract float getEyeHeight(Pose var1, EntityDimensions var2);

    @Shadow
    public abstract Pose getPose();

    @Shadow
    public abstract EntityDimensions getDimensions(Pose var1);

    @Shadow
    protected abstract void reapplyPosition();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract Vec3 position();

    @Shadow
    public abstract void setPos(Vec3 var1);

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    public void init(EntityType<?> entityType, Level level, CallbackInfo ci) {
        EntitySizeEvents.UpdatedSize updatedSize = ((EntitySizeEvents.Size)EntitySizeEvents.SIZE.invoker()).size((Entity)this, Pose.STANDING, this.dimensions, this.getEyeHeight(Pose.STANDING, this.dimensions));
        this.dimensions = updatedSize.getNewSize();
        this.eyeHeight = updatedSize.getNewEyeHeight();
    }

    @Overwrite
    public void refreshDimensions() {
        boolean bl;
        EntityDimensions entityDimensions = this.dimensions;
        Pose pose = this.getPose();
        EntityDimensions entityDimensions2 = this.getDimensions(pose);
        EntitySizeEvents.UpdatedSize updatedSize = ((EntitySizeEvents.Size)EntitySizeEvents.SIZE.invoker()).size((Entity)this, pose, entityDimensions, this.getEyeHeight(pose, entityDimensions2));
        this.dimensions = entityDimensions2 = updatedSize.getNewSize();
        this.eyeHeight = updatedSize.getNewEyeHeight();
        this.reapplyPosition();
        boolean bl2 = bl = (double)entityDimensions2.width <= 4.0 && (double)entityDimensions2.height <= 4.0;
        if (!(this.level().isClientSide || this.firstTick || this.noPhysics || !bl || !(entityDimensions2.width > entityDimensions.width) && !(entityDimensions2.height > entityDimensions.height) || (Entity)this instanceof Player)) {
            Vec3 vec3 = this.position().add(0.0, (double)entityDimensions.height / 2.0, 0.0);
            double d = (double)Math.max(0.0f, entityDimensions2.width - entityDimensions.width) + 1.0E-6;
            double e = (double)Math.max(0.0f, entityDimensions2.height - entityDimensions.height) + 1.0E-6;
            VoxelShape voxelShape = Shapes.create((AABB)AABB.ofSize((Vec3)vec3, (double)d, (double)e, (double)d));
            EntityDimensions finalEntitydimensions = entityDimensions2;
            this.level().findFreePosition((Entity)this, voxelShape, vec3, (double)entityDimensions2.width, (double)entityDimensions2.height, (double)entityDimensions2.width).ifPresent(vec3x -> this.setPos(vec3x.add(0.0, (double)(-finalEntitydimensions.height) / 2.0, 0.0)));
        }
    }
}

