/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.mixins;

import net.gigabit101.shrink.api.ShrinkAPI;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Shadow
    public abstract EntityDimensions getDimensions(Pose var1);

    @Inject(method={"canPlayerFitWithinBlocksAndEntitiesWhen(Lnet/minecraft/world/entity/Pose;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void isPoseClear(Pose pose, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && ShrinkAPI.isEntityShrunk(livingEntity = (LivingEntity)entity)) {
            double scale = livingEntity.getAttributeValue(ShrinkAPI.SCALE_ATTRIBUTE);
            EntityDimensions entitysize = this.getDimensions(pose);
            entitysize = entitysize.scale((float)scale);
            float f = entitysize.width / 2.0f;
            Vec3 vector3d = new Vec3(livingEntity.getX() - (double)f, livingEntity.getY(), livingEntity.getZ() - (double)f);
            Vec3 vector3d1 = new Vec3(livingEntity.getX() + (double)f, livingEntity.getY() + (double)entitysize.height, livingEntity.getZ() + (double)f);
            AABB box = new AABB(vector3d, vector3d1);
            cir.setReturnValue((Object)livingEntity.level().noCollision((Entity)livingEntity, box.deflate(1.0E-7)));
        }
    }
}

