/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.items.ItemShrinkDevice;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PacketEntitySync {
    double scale;
    int id;
    boolean shrink;

    public PacketEntitySync(double scale, int id, boolean shrink) {
        this.scale = scale;
        this.id = id;
        this.shrink = shrink;
    }

    public PacketEntitySync(FriendlyByteBuf buf) {
        this.scale = buf.readDouble();
        this.id = buf.readInt();
        this.shrink = buf.readBoolean();
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeDouble(this.scale);
        friendlyByteBuf.writeInt(this.id);
        friendlyByteBuf.writeBoolean(this.shrink);
    }

    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)context.get()).getPlayer();
            Level level = player.level();
            if (level != null && level.getEntity(this.id) != null) {
                LivingEntity livingEntity = (LivingEntity)level.getEntity(this.id);
                if (!ShrinkAPI.isEntityShrunk(livingEntity)) {
                    livingEntity.getAttribute(ShrinkAPI.SCALE_ATTRIBUTE).addPermanentModifier(ItemShrinkDevice.createModifier(this.scale));
                } else {
                    livingEntity.getAttribute(ShrinkAPI.SCALE_ATTRIBUTE).removeModifier(ItemShrinkDevice.SHRINKING_DEVICE_ID);
                }
                livingEntity.refreshDimensions();
            } else {
                System.out.println("entity with id " + this.id + " does not exist");
            }
        });
    }
}

