/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.gigabit101.shrink.items.ItemShrinkDevice;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PacketShrinkDevice {
    InteractionHand hand;
    double scale;

    public PacketShrinkDevice(InteractionHand hand, double scale) {
        this.hand = hand;
        this.scale = scale;
    }

    public PacketShrinkDevice(FriendlyByteBuf friendlyByteBuf) {
        this.hand = friendlyByteBuf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.scale = friendlyByteBuf.readDouble();
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        friendlyByteBuf.writeDouble(this.scale);
    }

    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            Item patt1321$temp;
            Player player = ((NetworkManager.PacketContext)context.get()).getPlayer();
            if (player == null) {
                return;
            }
            ItemStack stack = player.getItemInHand(this.hand);
            if (!stack.isEmpty() && (patt1321$temp = stack.getItem()) instanceof ItemShrinkDevice) {
                ItemShrinkDevice itemShrinkDevice = (ItemShrinkDevice)patt1321$temp;
                itemShrinkDevice.writeScale(stack, this.scale);
            }
        });
    }
}

