/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.jei.ghostfilterhandlers;

import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.network.data.GhostSlotPayload;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class GhostFilterCard
implements IGhostIngredientHandler<CardItemScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(CardItemScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (final Slot slot : ((CardItemContainer)gui.getMenu()).slots) {
            if (!slot.isActive()) continue;
            final Rect2i bounds = new Rect2i(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 16, 16);
            if (ingredient.getIngredient() instanceof ItemStack && slot instanceof FilterBasicSlot) {
                targets.add(new IGhostIngredientHandler.Target<I>(){

                    public Rect2i getArea() {
                        return bounds;
                    }

                    public void accept(I ingredient) {
                        ItemStack itemStack = (ItemStack)ingredient;
                        slot.set(itemStack.copy());
                        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GhostSlotPayload(slot.index, itemStack, itemStack.getCount(), -1)});
                    }
                });
                continue;
            }
            if (!(ingredient instanceof FluidStack) || !(slot instanceof FilterBasicSlot)) continue;
            targets.add(new IGhostIngredientHandler.Target<I>(){

                public Rect2i getArea() {
                    return bounds;
                }

                public void accept(I ingredient) {
                    ItemStack itemStack = new ItemStack((ItemLike)((FluidStack)ingredient).getFluid().getBucket(), 1);
                    slot.set(itemStack.copy());
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GhostSlotPayload(slot.index, itemStack, itemStack.getCount(), -1)});
                }
            });
        }
        return targets;
    }

    public void onComplete() {
    }
}

