/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.renderer;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.client.events.ClientEvents;
import com.direwolf20.laserio.client.renderer.MyRenderType;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.items.LaserWrench;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.CardRender;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderUtils {
    public static void render(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color, float scale) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.5f;
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
    }

    public static void drawLasersTile(BlockEntity be, BlockPos startBlock, BlockPos endBlock, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        Level level = be.getLevel();
        long gameTime = level.getGameTime();
        double v = (double)gameTime * 0.04;
        float diffX = (float)endBlock.getX() + 0.5f - (float)startBlock.getX();
        float diffY = (float)endBlock.getY() + 0.5f - (float)startBlock.getY();
        float diffZ = (float)endBlock.getZ() + 0.5f - (float)startBlock.getZ();
        matrixStackIn.pushPose();
        Matrix4f positionMatrix = matrixStackIn.last().pose();
        VertexConsumer builder = bufferIn.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, 1.0f, 0.0f, 0.0f, 0.5f, 0.025f, v, v + (double)diffY * 1.5, be);
        matrixStackIn.popPose();
    }

    public static void drawLasersLast(BlockEntity be, BlockPos startBlock, BlockPos endBlock, PoseStack matrixStackIn) {
        Level level = be.getLevel();
        long gameTime = level.getGameTime();
        double v = (double)gameTime * 0.04;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        float diffX = (float)endBlock.getX() + 0.5f - (float)startBlock.getX();
        float diffY = (float)endBlock.getY() + 0.5f - (float)startBlock.getY();
        float diffZ = (float)endBlock.getZ() + 0.5f - (float)startBlock.getZ();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        matrixStackIn.pushPose();
        Matrix4f positionMatrix = matrixStackIn.last().pose();
        matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
        VertexConsumer builder = buffer.getBuffer(MyRenderType.CONNECTING_LASER);
        Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, 1.0f, 0.0f, 0.0f, 0.33f, 0.025f, v, v + (double)diffY * 1.5, be);
        matrixStackIn.popPose();
        buffer.endBatch(MyRenderType.CONNECTING_LASER);
    }

    public static void drawLasersLast2(Queue<BaseLaserBE> beRenders, PoseStack matrixStackIn) {
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        VertexConsumer builder = buffer.getBuffer(MyRenderType.CONNECTING_LASER);
        while (beRenders.size() > 0) {
            LaserConnectorAdvBE laserConnectorAdvBE;
            int alpha;
            ItemStack myItem;
            LocalPlayer myplayer;
            Color color;
            BlockPos endBlock;
            BaseLaserBE be = beRenders.remove();
            Level level = be.getLevel();
            long gameTime = level.getGameTime();
            double v = (double)gameTime * 0.04;
            BlockPos startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            Matrix4f positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
            for (BlockPos target : be.getRenderedConnections()) {
                endBlock = be.getWorldPos(target);
                color = be.getColor();
                myplayer = Minecraft.getInstance().player;
                myItem = ClientEvents.getWrench((Player)myplayer);
                alpha = myItem.getItem() instanceof LaserWrench ? Math.min(color.getAlpha() + be.getWrenchAlpha(), 255) : color.getAlpha();
                float diffX = (float)endBlock.getX() + 0.5f - (float)startBlock.getX();
                float diffY = (float)endBlock.getY() + 0.5f - (float)startBlock.getY();
                float diffZ = (float)endBlock.getZ() + 0.5f - (float)startBlock.getZ();
                Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)alpha / 255.0f, 0.025f, v, v + (double)diffY * 1.5, be);
            }
            if (be instanceof LaserConnectorAdvBE && (laserConnectorAdvBE = (LaserConnectorAdvBE)be).getPartnerDimBlockPos() != null && level.getBlockState(be.getBlockPos()).getBlock().equals(Registration.LaserConnectorAdv.get())) {
                Direction facing = ((Direction)level.getBlockState(be.getBlockPos()).getValue((Property)BlockStateProperties.FACING)).getOpposite();
                endBlock = laserConnectorAdvBE.getBlockPos().relative(facing);
                color = be.getColor();
                myplayer = Minecraft.getInstance().player;
                myItem = ClientEvents.getWrench((Player)myplayer);
                alpha = myItem.getItem() instanceof LaserWrench ? Math.min(color.getAlpha() + be.getWrenchAlpha(), 255) : color.getAlpha();
                Vector3f endLaser = RenderUtils.calculateEndAdvConnector(startBlock, endBlock, facing);
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)alpha / 255.0f, 0.025f, v, v + (double)endLaser.y() * 1.5, be);
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.CONNECTING_LASER);
    }

    public static Vector3f calculateEndAdvConnector(BlockPos startBlock, BlockPos endBlock, Direction facing) {
        float diffX = endBlock.getX() - startBlock.getX();
        float diffY = endBlock.getY() - startBlock.getY();
        float diffZ = endBlock.getZ() - startBlock.getZ();
        switch (facing) {
            case UP: {
                diffX += 0.5f;
                diffY -= 0.25f;
                diffZ += 0.5f;
                break;
            }
            case DOWN: {
                diffX += 0.5f;
                diffY += 1.25f;
                diffZ += 0.5f;
                break;
            }
            case NORTH: {
                diffX += 0.5f;
                diffY += 0.5f;
                diffZ += 1.25f;
                break;
            }
            case SOUTH: {
                diffX += 0.5f;
                diffY += 0.5f;
                diffZ -= 0.25f;
                break;
            }
            case EAST: {
                diffX -= 0.25f;
                diffY += 0.5f;
                diffZ += 0.5f;
                break;
            }
            case WEST: {
                diffX += 1.25f;
                diffY += 0.5f;
                diffZ += 0.5f;
                break;
            }
        }
        return new Vector3f(diffX, diffY, diffZ);
    }

    public static void drawConnectingLasersLast4(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn) {
        Matrix4f positionMatrix;
        BlockPos startBlock;
        double v;
        long gameTime;
        Level level;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float alpha = 1.0f;
        float thickness = 0.0175f;
        VertexConsumer builder = buffer.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.getLevel();
            gameTime = level.getGameTime();
            v = (double)gameTime * 0.04;
            startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.r, cardRender.g, cardRender.b, alpha, thickness, v, v + (double)cardRender.diffY * 4.5, be);
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_CORE);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.getLevel();
            gameTime = level.getGameTime();
            v = (double)gameTime * 0.04;
            startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.floatcolors[0], cardRender.floatcolors[1], cardRender.floatcolors[2], 1.0f, 0.0125f, v, v + (double)cardRender.diffY * 1.5, be);
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_CORE);
    }

    public static void drawConnectingLasersLast3(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn) {
        ItemStack card;
        int slot;
        IItemHandler h;
        Matrix4f positionMatrix;
        BlockPos startBlock;
        double v;
        long gameTime;
        Level level;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float r = 0.0f;
        float g = 1.0f;
        float b = 0.0f;
        float alpha = 1.0f;
        float thickness = 0.0175f;
        VertexConsumer builder = buffer.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.getLevel();
            gameTime = level.getGameTime();
            v = (double)gameTime * 0.04;
            startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            for (Direction direction : Direction.values()) {
                h = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)direction);
                if (h == null) continue;
                for (slot = 0; slot < h.getSlots(); ++slot) {
                    Vector3f startLaser;
                    Vector3f endLaser;
                    boolean reverse;
                    card = h.getStackInSlot(slot);
                    if (!(card.getItem() instanceof BaseCard) || ((BaseCard)card.getItem()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1) == null) continue;
                    boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                    if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                        reverse = !reverse;
                    }
                    BlockPos endBlock = startBlock.relative(direction);
                    Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                    float diffX = (float)endBlock.getX() + offset.x() - (float)startBlock.getX();
                    float diffY = (float)endBlock.getY() + offset.y() - (float)startBlock.getY();
                    float diffZ = (float)endBlock.getZ() + offset.z() - (float)startBlock.getZ();
                    if (reverse) {
                        endLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                        startLaser = new Vector3f(diffX, diffY, diffZ);
                    } else {
                        startLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                        endLaser = new Vector3f(diffX, diffY, diffZ);
                    }
                    RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
                }
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_CORE);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.getLevel();
            gameTime = level.getGameTime();
            v = (double)gameTime * 0.04;
            startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            for (Direction direction : Direction.values()) {
                h = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)direction);
                if (h == null) continue;
                for (slot = 0; slot < h.getSlots(); ++slot) {
                    Vector3f startLaser;
                    Vector3f endLaser;
                    boolean reverse;
                    card = h.getStackInSlot(slot);
                    if (!(card.getItem() instanceof BaseCard) || ((BaseCard)card.getItem()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1) == null) continue;
                    float[] floatcolors = LaserNodeBERender.colors[BaseCard.getChannel(card)].getColorComponents(new float[3]);
                    boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                    if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                        reverse = !reverse;
                    }
                    BlockPos endBlock = startBlock.relative(direction);
                    Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                    float diffX = (float)endBlock.getX() + offset.x() - (float)startBlock.getX();
                    float diffY = (float)endBlock.getY() + offset.y() - (float)startBlock.getY();
                    float diffZ = (float)endBlock.getZ() + offset.z() - (float)startBlock.getZ();
                    if (reverse) {
                        endLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                        startLaser = new Vector3f(diffX, diffY, diffZ);
                    } else {
                        startLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                        endLaser = new Vector3f(diffX, diffY, diffZ);
                    }
                    RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, floatcolors[0], floatcolors[1], floatcolors[2], 1.0f, 0.0125f, v, v + (double)diffY * 1.5, be);
                }
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_CORE);
    }

    public static void drawConnectingLasersLast2(LaserNodeBE be, PoseStack matrixStackIn) {
        ItemStack card;
        int slot;
        IItemHandler h;
        Level level = be.getLevel();
        long gameTime = level.getGameTime();
        double v = (double)gameTime * 0.04;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float r = 0.0f;
        float g = 1.0f;
        float b = 0.0f;
        float alpha = 1.0f;
        float thickness = 0.0175f;
        BlockPos startBlock = be.getBlockPos();
        matrixStackIn.pushPose();
        Matrix4f positionMatrix = matrixStackIn.last().pose();
        matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
        VertexConsumer builder = buffer.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        for (Direction direction : Direction.values()) {
            h = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)direction);
            if (h == null) continue;
            for (slot = 0; slot < h.getSlots(); ++slot) {
                Vector3f startLaser;
                Vector3f endLaser;
                boolean reverse;
                card = h.getStackInSlot(slot);
                if (!(card.getItem() instanceof BaseCard) || ((BaseCard)card.getItem()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1) == null) continue;
                boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                    reverse = !reverse;
                }
                BlockPos endBlock = startBlock.relative(direction);
                Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                float diffX = (float)endBlock.getX() + offset.x() - (float)startBlock.getX();
                float diffY = (float)endBlock.getY() + offset.y() - (float)startBlock.getY();
                float diffZ = (float)endBlock.getZ() + offset.z() - (float)startBlock.getZ();
                if (reverse) {
                    endLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                    startLaser = new Vector3f(diffX, diffY, diffZ);
                } else {
                    startLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                    endLaser = new Vector3f(diffX, diffY, diffZ);
                }
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
            }
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_CORE);
        for (Direction direction : Direction.values()) {
            h = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)direction);
            if (h == null) continue;
            for (slot = 0; slot < h.getSlots(); ++slot) {
                Vector3f startLaser;
                Vector3f endLaser;
                boolean reverse;
                card = h.getStackInSlot(slot);
                if (!(card.getItem() instanceof BaseCard) || ((BaseCard)card.getItem()).getCardType() != BaseCard.CardType.ITEM || be.getAttachedInventoryNoCache(direction, (byte)-1) == null) continue;
                float[] floatcolors = LaserNodeBERender.colors[BaseCard.getChannel(card)].getColorComponents(new float[3]);
                boolean bl = reverse = !direction.equals((Object)Direction.DOWN);
                if (BaseCard.getNamedTransferMode(card) != BaseCard.TransferMode.EXTRACT) {
                    reverse = !reverse;
                }
                BlockPos endBlock = startBlock.relative(direction);
                Vector3f offset = MiscTools.findOffset(direction, slot, LaserNodeBERender.offsets);
                float diffX = (float)endBlock.getX() + offset.x() - (float)startBlock.getX();
                float diffY = (float)endBlock.getY() + offset.y() - (float)startBlock.getY();
                float diffZ = (float)endBlock.getZ() + offset.z() - (float)startBlock.getZ();
                if (reverse) {
                    endLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                    startLaser = new Vector3f(diffX, diffY, diffZ);
                } else {
                    startLaser = new Vector3f(offset.x(), offset.y(), offset.z());
                    endLaser = new Vector3f(diffX, diffY, diffZ);
                }
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, floatcolors[0], floatcolors[1], floatcolors[2], 1.0f, 0.0125f, v, v + (double)diffY * 1.5, be);
            }
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_CORE);
        matrixStackIn.popPose();
    }

    public static void drawConnectingLasersLast(BlockEntity be, BlockPos startBlock, BlockPos endBlock, PoseStack matrixStackIn, MultiBufferSource bufferIn, Vector3f offset, float r, float g, float b, float alpha, float thickness, float r2, float g2, float b2, float alpha2, float thickness2, boolean reverse) {
        Vector3f startLaser;
        Vector3f endLaser;
        Level level = be.getLevel();
        long gameTime = level.getGameTime();
        double v = (double)gameTime * 0.04;
        float diffX = (float)endBlock.getX() + offset.x() - (float)startBlock.getX();
        float diffY = (float)endBlock.getY() + offset.y() - (float)startBlock.getY();
        float diffZ = (float)endBlock.getZ() + offset.z() - (float)startBlock.getZ();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        matrixStackIn.pushPose();
        Matrix4f positionMatrix = matrixStackIn.last().pose();
        matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
        if (reverse) {
            endLaser = new Vector3f(offset.x(), offset.y(), offset.z());
            startLaser = new Vector3f(diffX, diffY, diffZ);
        } else {
            startLaser = new Vector3f(offset.x(), offset.y(), offset.z());
            endLaser = new Vector3f(diffX, diffY, diffZ);
        }
        VertexConsumer builder = buffer.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
        buffer.endBatch(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_CORE);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r2, g2, b2, alpha2, thickness2, v, v + (double)diffY * 1.5, be);
        buffer.endBatch(MyRenderType.LASER_MAIN_CORE);
        matrixStackIn.popPose();
    }

    public static void drawConnectingLasers(BlockEntity be, BlockPos startBlock, BlockPos endBlock, PoseStack matrixStackIn, MultiBufferSource bufferIn, Vector3f offset, float r, float g, float b, float alpha, float thickness, float r2, float g2, float b2, float alpha2, float thickness2, boolean reverse) {
        Vector3f startLaser;
        Vector3f endLaser;
        Level level = be.getLevel();
        long gameTime = level.getGameTime();
        double v = (double)gameTime * 0.04;
        float diffX = (float)endBlock.getX() + offset.x() - (float)startBlock.getX();
        float diffY = (float)endBlock.getY() + offset.y() - (float)startBlock.getY();
        float diffZ = (float)endBlock.getZ() + offset.z() - (float)startBlock.getZ();
        matrixStackIn.pushPose();
        Matrix4f positionMatrix = matrixStackIn.last().pose();
        if (reverse) {
            endLaser = new Vector3f(offset.x(), offset.y(), offset.z());
            startLaser = new Vector3f(diffX, diffY, diffZ);
        } else {
            startLaser = new Vector3f(offset.x(), offset.y(), offset.z());
            endLaser = new Vector3f(diffX, diffY, diffZ);
        }
        VertexConsumer builder = bufferIn.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r, g, b, alpha, thickness, v, v + (double)diffY * 4.5, be);
        builder = bufferIn.getBuffer(MyRenderType.LASER_MAIN_CORE);
        RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, r2, g2, b2, alpha2, thickness2, v, v + (double)diffY * 1.5, be);
        matrixStackIn.popPose();
    }

    public static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockEntity be) {
        LocalPlayer player = Minecraft.getInstance().player;
        Vector3f P = new Vector3f((float)player.getX() - (float)be.getBlockPos().getX(), (float)player.getEyeY() - (float)be.getBlockPos().getY(), (float)player.getZ() - (float)be.getBlockPos().getZ());
        Vector3f PS = new Vector3f((Vector3fc)from);
        PS.sub((Vector3fc)P);
        Vector3f SE = new Vector3f((Vector3fc)to);
        SE.sub((Vector3fc)from);
        Vector3f adjustedVec = new Vector3f((Vector3fc)PS);
        adjustedVec.cross((Vector3fc)SE);
        adjustedVec.normalize();
        return adjustedVec;
    }

    public static void drawLaser(VertexConsumer builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, double v1, double v2, BlockEntity be) {
        Vector3f adjustedVec = RenderUtils.adjustBeamToEyes(from, to, be);
        adjustedVec.mul(thickness);
        Vector3f p1 = new Vector3f((Vector3fc)from);
        p1.add((Vector3fc)adjustedVec);
        Vector3f p2 = new Vector3f((Vector3fc)from);
        p2.sub((Vector3fc)adjustedVec);
        Vector3f p3 = new Vector3f((Vector3fc)to);
        p3.add((Vector3fc)adjustedVec);
        Vector3f p4 = new Vector3f((Vector3fc)to);
        p4.sub((Vector3fc)adjustedVec);
        builder.vertex(positionMatrix, p1.x(), p1.y(), p1.z()).color(r, g, b, alpha).uv(1.0f, (float)v1).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(0xF000F0).endVertex();
        builder.vertex(positionMatrix, p3.x(), p3.y(), p3.z()).color(r, g, b, alpha).uv(1.0f, (float)v2).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(0xF000F0).endVertex();
        builder.vertex(positionMatrix, p4.x(), p4.y(), p4.z()).color(r, g, b, alpha).uv(0.0f, (float)v2).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(0xF000F0).endVertex();
        builder.vertex(positionMatrix, p2.x(), p2.y(), p2.z()).color(r, g, b, alpha).uv(0.0f, (float)v1).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(0xF000F0).endVertex();
    }
}

