/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.network.data.OpenNodePayload;
import com.direwolf20.laserio.common.network.data.UpdateCardPayload;
import com.direwolf20.laserio.setup.Config;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class CardEnergyScreen
extends AbstractContainerScreen<CardEnergyContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/energycard.png");
    protected final CardEnergyContainer container;
    protected byte currentMode;
    protected byte currentChannel;
    protected byte currentRedstoneChannel;
    protected int currentEnergyExtractAmt;
    protected short currentPriority;
    protected byte currentSneaky;
    protected int currentTicks;
    protected boolean currentExact;
    protected int currentRoundRobin;
    protected boolean currentRegulate;
    protected int currentExtractLimitPercent;
    protected int currentInsertLimitPercent;
    protected final ItemStack card;
    protected Map<String, Button> buttons = new HashMap<String, Button>();
    protected byte currentRedstoneMode;
    protected final String[] sneakyNames = new String[]{"screen.laserio.default", "screen.laserio.down", "screen.laserio.up", "screen.laserio.north", "screen.laserio.south", "screen.laserio.west", "screen.laserio.east"};

    public CardEnergyScreen(CardEnergyContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Button limitButton;
        Button speedButton;
        Button exact;
        Button redstoneMode;
        Button roundrobin;
        Button regulate;
        Button amountButton;
        Button sneakyButton;
        Button redstoneChannelButton;
        Button channelButton;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.getX(), modeButton.getY(), modeButton.getWidth(), modeButton.getHeight(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.translatable((String)"screen.laserio.insert"), Component.translatable((String)"screen.laserio.extract"), Component.translatable((String)"screen.laserio.stock"), Component.translatable((String)"screen.laserio.sensor")};
            guiGraphics.renderTooltip(this.font, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (MiscTools.inBounds((channelButton = this.buttons.get("channel")).getX(), channelButton.getY(), channelButton.getWidth(), channelButton.getHeight(), mouseX, mouseY) && this.currentMode != 3) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.channel").append(String.valueOf(this.currentChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds((redstoneChannelButton = this.buttons.get("redstoneChannel")).getX(), redstoneChannelButton.getY(), redstoneChannelButton.getWidth(), redstoneChannelButton.getHeight(), mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.redstonechannel").append(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds((sneakyButton = this.buttons.get("sneaky")).getX(), sneakyButton.getY(), sneakyButton.getWidth(), sneakyButton.getHeight(), mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)String.valueOf(this.sneakyNames[this.currentSneaky + 1])), mouseX, mouseY);
        }
        if (MiscTools.inBounds((amountButton = this.buttons.get("amount")).getX(), amountButton.getY(), amountButton.getWidth(), amountButton.getHeight(), mouseX, mouseY)) {
            if (this.showExtractAmt()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.extractamt"), mouseX, mouseY);
            }
            if (this.showPriority()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.priority"), mouseX, mouseY);
            }
        }
        if (MiscTools.inBounds((regulate = this.buttons.get("regulate")).getX(), regulate.getY(), regulate.getWidth(), regulate.getHeight(), mouseX, mouseY) && this.showRegulate()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.regulate"), mouseX, mouseY);
        }
        if (MiscTools.inBounds((roundrobin = this.buttons.get("roundrobin")).getX(), roundrobin.getY(), roundrobin.getWidth(), roundrobin.getHeight(), mouseX, mouseY) && this.showRoundRobin()) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.translatable((String)"screen.laserio.false"), Component.translatable((String)"screen.laserio.true"), Component.translatable((String)"screen.laserio.enforced")};
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.roundrobin").append((Component)translatableComponents[this.currentRoundRobin]), mouseX, mouseY);
        }
        if (MiscTools.inBounds((redstoneMode = this.buttons.get("redstoneMode")).getX(), redstoneMode.getY(), redstoneMode.getWidth(), redstoneMode.getHeight(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.translatable((String)"screen.laserio.ignored"), Component.translatable((String)"screen.laserio.low"), Component.translatable((String)"screen.laserio.high")};
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.redstoneMode").append((Component)translatableComponents[this.currentRedstoneMode]), mouseX, mouseY);
        }
        if (MiscTools.inBounds((exact = this.buttons.get("exact")).getX(), exact.getY(), exact.getWidth(), exact.getHeight(), mouseX, mouseY) && this.showExactAmt()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.exact"), mouseX, mouseY);
        }
        if (MiscTools.inBounds((speedButton = this.buttons.get("speed")).getX(), speedButton.getY(), speedButton.getWidth(), speedButton.getHeight(), mouseX, mouseY) && this.showExactAmt()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.tickSpeed"), mouseX, mouseY);
        }
        if (MiscTools.inBounds((limitButton = this.buttons.get("limit")).getX(), limitButton.getY(), limitButton.getWidth(), limitButton.getHeight(), mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.energylimit"), mouseX, mouseY);
        }
    }

    public void addAmtButton() {
        this.buttons.put("amount", new NumberButton(this.getGuiLeft() + 125, this.getGuiTop() + 25, 46, 12, this.currentMode == 0 ? this.currentPriority : this.currentEnergyExtractAmt, button -> this.changeAmount(-1)));
    }

    public void addLimitButton() {
        this.buttons.put("limit", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 53, 24, 12, this.showExtractLimit() ? this.currentExtractLimitPercent : this.currentInsertLimitPercent, button -> this.changeLimitAmount(-1)));
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/modeinserter.png"), new ResourceLocation("laserio", "textures/gui/buttons/modeextractor.png"), new ResourceLocation("laserio", "textures/gui/buttons/modestocker.png"), new ResourceLocation("laserio", "textures/gui/buttons/modesensor.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = BaseCard.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            ((NumberButton)this.buttons.get("amount")).setValue(this.currentMode == 0 ? this.currentPriority : this.currentEnergyExtractAmt);
            ((NumberButton)this.buttons.get("limit")).setValue(this.showExtractLimit() ? this.currentExtractLimitPercent : this.currentInsertLimitPercent);
            this.modeChange();
        }));
    }

    public void addRedstoneButton() {
        ResourceLocation[] redstoneTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneignore.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("redstoneMode", new ToggleButton(this.getGuiLeft() + 105, this.getGuiTop() + 5, 16, 16, redstoneTextures, this.currentRedstoneMode, button -> {
            this.currentRedstoneMode = (byte)(this.currentRedstoneMode == 2 ? 0 : this.currentRedstoneMode + 1);
            ((ToggleButton)button).setTexturePosition(this.currentRedstoneMode);
        }));
    }

    public void addRedstoneChannelButton() {
        this.buttons.put("redstoneChannel", new ChannelButton(this.getGuiLeft() + 125, this.getGuiTop() + 5, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void init() {
        super.init();
        this.currentMode = BaseCard.getTransferMode(this.card);
        this.currentChannel = BaseCard.getChannel(this.card);
        this.currentEnergyExtractAmt = CardEnergy.getEnergyExtractAmt(this.card);
        this.currentPriority = BaseCard.getPriority(this.card);
        this.currentSneaky = BaseCard.getSneaky(this.card);
        this.currentTicks = CardEnergy.getExtractSpeed(this.card);
        this.currentExact = BaseCard.getExact(this.card);
        this.currentRoundRobin = BaseCard.getRoundRobin(this.card);
        this.currentRegulate = BaseCard.getRegulate(this.card);
        this.currentExtractLimitPercent = CardEnergy.getExtractLimitPercent(this.card);
        this.currentInsertLimitPercent = CardEnergy.getInsertLimitPercent(this.card);
        this.currentRedstoneMode = CardEnergy.getRedstoneMode(this.card);
        this.currentRedstoneChannel = BaseCard.getRedstoneChannel(this.card);
        this.addAmtButton();
        this.addLimitButton();
        this.buttons.put("speed", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 39, 24, 12, this.currentTicks, button -> this.changeTick(-1)));
        ResourceLocation[] exactTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/exactfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/exacttrue.png")};
        this.buttons.put("exact", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 25, 16, 16, exactTextures, this.currentExact ? 1 : 0, button -> {
            this.currentExact = !this.currentExact;
            ((ToggleButton)button).setTexturePosition(this.currentExact ? 1 : 0);
        }));
        ResourceLocation[] roundRobinTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/roundrobinfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/roundrobintrue.png"), new ResourceLocation("laserio", "textures/gui/buttons/roundrobinenforced.png")};
        this.buttons.put("roundrobin", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, roundRobinTextures, this.currentRoundRobin, button -> {
            this.currentRoundRobin = this.currentRoundRobin == 2 ? 0 : this.currentRoundRobin + 1;
            ((ToggleButton)button).setTexturePosition(this.currentRoundRobin);
        }));
        ResourceLocation[] regulateTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/regulatefalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/regulatetrue.png")};
        this.buttons.put("regulate", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, regulateTextures, this.currentRegulate ? 1 : 0, button -> {
            this.currentRegulate = !this.currentRegulate;
            ((ToggleButton)button).setTexturePosition(this.currentRegulate ? 1 : 0);
        }));
        this.addModeButton();
        this.addRedstoneButton();
        this.addRedstoneChannelButton();
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentChannel, button -> {
            this.currentChannel = BaseCard.nextChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentChannel);
        }));
        ResourceLocation[] sneakyTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/sneaky.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-down.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-up.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-north.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-south.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-west.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-east.png")};
        this.buttons.put("sneaky", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 5, 16, 16, sneakyTextures, this.currentSneaky + 1, button -> {
            this.currentSneaky = BaseCard.nextSneaky(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentSneaky + 1);
        }));
        if (this.container.direction != -1) {
            this.buttons.put("return", (Button)new ExtendedButton(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.literal((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.addRenderableWidget((GuiEventListener)button2.getValue());
        }
        this.modeChange();
    }

    public void modeChange() {
        Button speedButton = this.buttons.get("speed");
        Button exactButton = this.buttons.get("exact");
        Button rrButton = this.buttons.get("roundrobin");
        Button regulateButton = this.buttons.get("regulate");
        Button channelButton = this.buttons.get("channel");
        Button amountButton = this.buttons.get("amount");
        if (this.currentMode == 0) {
            if (!this.renderables.contains(channelButton)) {
                this.addRenderableWidget((GuiEventListener)channelButton);
            }
            if (!this.renderables.contains(amountButton)) {
                this.addRenderableWidget((GuiEventListener)amountButton);
            }
            this.removeWidget((GuiEventListener)speedButton);
            this.removeWidget((GuiEventListener)exactButton);
            this.removeWidget((GuiEventListener)rrButton);
            this.removeWidget((GuiEventListener)regulateButton);
        } else if (this.currentMode == 1) {
            if (!this.renderables.contains(channelButton)) {
                this.addRenderableWidget((GuiEventListener)channelButton);
            }
            if (!this.renderables.contains(amountButton)) {
                this.addRenderableWidget((GuiEventListener)amountButton);
            }
            if (!this.renderables.contains(speedButton)) {
                this.addRenderableWidget((GuiEventListener)speedButton);
            }
            if (!this.renderables.contains(exactButton)) {
                this.addRenderableWidget((GuiEventListener)exactButton);
            }
            if (!this.renderables.contains(rrButton)) {
                this.addRenderableWidget((GuiEventListener)rrButton);
            }
            this.removeWidget((GuiEventListener)regulateButton);
        } else if (this.currentMode == 2) {
            if (!this.renderables.contains(channelButton)) {
                this.addRenderableWidget((GuiEventListener)channelButton);
            }
            if (!this.renderables.contains(amountButton)) {
                this.addRenderableWidget((GuiEventListener)amountButton);
            }
            if (!this.renderables.contains(speedButton)) {
                this.addRenderableWidget((GuiEventListener)speedButton);
            }
            if (!this.renderables.contains(exactButton)) {
                this.addRenderableWidget((GuiEventListener)exactButton);
            }
            if (!this.renderables.contains(regulateButton)) {
                this.addRenderableWidget((GuiEventListener)regulateButton);
            }
            this.removeWidget((GuiEventListener)rrButton);
        } else if (this.currentMode == 3) {
            if (!this.renderables.contains(speedButton)) {
                this.addRenderableWidget((GuiEventListener)speedButton);
            }
            this.removeWidget((GuiEventListener)rrButton);
            this.removeWidget((GuiEventListener)regulateButton);
            this.removeWidget((GuiEventListener)channelButton);
            this.removeWidget((GuiEventListener)amountButton);
        }
    }

    public void changeAmount(int change) {
        if (Screen.hasShiftDown()) {
            change *= 10;
        }
        if (Screen.hasControlDown()) {
            change *= 100;
        }
        int max = (Integer)Config.MAX_FE_TICK.get();
        if (change < 0) {
            if (this.currentMode == 0) {
                this.currentPriority = (short)Math.max(this.currentPriority + change, -4096);
            } else {
                this.currentEnergyExtractAmt = Math.max(this.currentEnergyExtractAmt + change, 100);
            }
        } else if (this.currentMode == 0) {
            this.currentPriority = (short)Math.min(this.currentPriority + change, 4096);
        } else {
            this.currentEnergyExtractAmt = Math.min(this.currentEnergyExtractAmt + change, max);
        }
    }

    public void changeLimitAmount(int change) {
        if (Screen.hasShiftDown()) {
            change *= 10;
        }
        if (Screen.hasControlDown()) {
            change *= 100;
        }
        if (change < 0) {
            if (this.showExtractLimit()) {
                this.currentExtractLimitPercent = Math.max(this.currentExtractLimitPercent + change, 0);
            } else {
                this.currentInsertLimitPercent = Math.max(this.currentInsertLimitPercent + change, 0);
            }
        } else if (this.showExtractLimit()) {
            this.currentExtractLimitPercent = Math.min(this.currentExtractLimitPercent + change, 100);
        } else {
            this.currentInsertLimitPercent = Math.min(this.currentInsertLimitPercent + change, 100);
        }
    }

    public void changeTick(int change) {
        if (Screen.hasShiftDown()) {
            change *= 10;
        }
        if (Screen.hasControlDown()) {
            change *= 64;
        }
        this.currentTicks = change < 0 ? Math.max(this.currentTicks + change, 1) : Math.min(this.currentTicks + change, 1200);
    }

    private boolean showExtractAmt() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT;
    }

    private boolean showExactAmt() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT;
    }

    private boolean showPriority() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.INSERT;
    }

    private boolean showRegulate() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.STOCK;
    }

    private boolean showRoundRobin() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.EXTRACT;
    }

    private boolean showExtractLimit() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.EXTRACT;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.saveSettings();
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        return super.mouseScrolled(mouseX, mouseY, delta, deltaY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("laserio." + key), (Object[])args);
    }

    public void setExtract(NumberButton amountButton, int btn) {
        int change;
        int n = change = this.currentMode == 0 ? 1 : 100;
        if (btn == 0) {
            this.changeAmount(change);
        } else if (btn == 1) {
            this.changeAmount(change * -1);
        }
        amountButton.setValue(this.currentMode == 0 ? this.currentPriority : this.currentEnergyExtractAmt);
        amountButton.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    public void setLimitExtract(NumberButton amountButton, int btn) {
        if (btn == 0) {
            this.changeLimitAmount(1);
        } else if (btn == 1) {
            this.changeLimitAmount(-1);
        }
        amountButton.setValue(this.showExtractLimit() ? this.currentExtractLimitPercent : this.currentInsertLimitPercent);
        amountButton.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    public void saveSettings() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateCardPayload(this.currentMode, this.currentChannel, this.currentEnergyExtractAmt, this.currentPriority, this.currentSneaky, (short)this.currentTicks, this.currentExact, this.currentRegulate, (byte)this.currentRoundRobin, this.currentExtractLimitPercent, this.currentInsertLimitPercent, this.currentRedstoneMode, this.currentRedstoneChannel, false)});
    }

    public void openNode() {
        this.saveSettings();
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.sourceContainer, this.container.direction)});
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean mouseClicked(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (this.currentMode != 3 && MiscTools.inBounds(channelButton.getX(), channelButton.getY(), channelButton.getWidth(), channelButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.currentChannel = BaseCard.nextChannel(this.card);
            } else if (btn == 1) {
                this.currentChannel = BaseCard.previousChannel(this.card);
            }
            channelButton.setChannel(this.currentChannel);
            channelButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        ToggleButton sneakyButton = (ToggleButton)this.buttons.get("sneaky");
        if (MiscTools.inBounds(sneakyButton.getX(), sneakyButton.getY(), sneakyButton.getWidth(), sneakyButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.currentSneaky = BaseCard.nextSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            } else if (btn == 1) {
                this.currentSneaky = BaseCard.previousSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            }
            sneakyButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        ChannelButton redstoneChannelButton = (ChannelButton)this.buttons.get("redstoneChannel");
        if (MiscTools.inBounds(redstoneChannelButton.getX(), redstoneChannelButton.getY(), redstoneChannelButton.getWidth(), redstoneChannelButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = BaseCard.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = BaseCard.previousRedstoneChannel(this.card);
            }
            redstoneChannelButton.setChannel(this.currentRedstoneChannel);
            redstoneChannelButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        NumberButton amountButton = (NumberButton)this.buttons.get("amount");
        if (MiscTools.inBounds(amountButton.getX(), amountButton.getY(), amountButton.getWidth(), amountButton.getHeight(), x, y)) {
            this.setExtract(amountButton, btn);
            return true;
        }
        NumberButton limitButton = (NumberButton)this.buttons.get("limit");
        if (MiscTools.inBounds(limitButton.getX(), limitButton.getY(), limitButton.getWidth(), limitButton.getHeight(), x, y)) {
            this.setLimitExtract(limitButton, btn);
            return true;
        }
        NumberButton speedButton = (NumberButton)this.buttons.get("speed");
        if (MiscTools.inBounds(speedButton.getX(), speedButton.getY(), speedButton.getWidth(), speedButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.changeTick(1);
            } else if (btn == 1) {
                this.changeTick(-1);
            }
            speedButton.setValue(this.currentTicks);
            speedButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return super.mouseClicked(x, y, btn);
    }
}

