/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.network.data.GhostSlotPayload;
import com.direwolf20.laserio.common.network.data.OpenNodePayload;
import com.direwolf20.laserio.common.network.data.UpdateCardPayload;
import com.direwolf20.laserio.common.network.data.UpdateFilterPayload;
import com.direwolf20.laserio.setup.Config;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class CardFluidScreen
extends CardItemScreen {
    public int currentFluidExtractAmt;
    public final int filterStartX;
    public final int filterStartY;
    public final int filterEndX;
    public final int filterEndY;

    public CardFluidScreen(CardItemContainer container, Inventory inv, Component name) {
        super(container, inv, name);
        this.filterStartX = 35;
        this.filterStartY = 16;
        this.filterEndX = 125;
        this.filterEndY = 70;
    }

    @Override
    public void init() {
        this.currentFluidExtractAmt = CardFluid.getFluidExtractAmt(this.card);
        super.init();
        Minecraft minecraft = Minecraft.getInstance();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels());
        this.renderFluids = true;
    }

    @Override
    public void addAmtButton() {
        this.buttons.put("amount", new NumberButton(this.getGuiLeft() + 141, this.getGuiTop() + 25, 30, 12, this.currentMode == 0 ? this.currentPriority : this.currentFluidExtractAmt, button -> this.changeAmount(-1)));
    }

    @Override
    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/modeinserter.png"), new ResourceLocation("laserio", "textures/gui/buttons/modeextractor.png"), new ResourceLocation("laserio", "textures/gui/buttons/modestocker.png"), new ResourceLocation("laserio", "textures/gui/buttons/modesensor.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = BaseCard.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            ((NumberButton)((Object)((Object)this.buttons.get("amount")))).setValue(this.currentMode == 0 ? this.currentPriority : this.currentFluidExtractAmt);
            this.modeChange();
        }));
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (((CardItemContainer)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            Optional fluidHandlerLazyOptional;
            ItemStack itemstack = this.hoveredSlot.getItem();
            if (this.hoveredSlot instanceof FilterBasicSlot && (fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)itemstack)).isPresent()) {
                FluidStack fluidStack = FluidStack.EMPTY;
                IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
                for (int tank = 0; tank < fluidHandler.getTanks() && (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty(); ++tank) {
                }
                if (!fluidStack.isEmpty()) {
                    pGuiGraphics.renderTooltip(this.font, fluidStack.getDisplayName(), pX, pY);
                    return;
                }
            }
            pGuiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, pX, pY);
        }
    }

    @Override
    public void changeAmount(int change) {
        if (Screen.hasShiftDown()) {
            change *= 10;
        }
        if (Screen.hasControlDown()) {
            change *= 100;
        }
        int overClockerCount = this.container.getSlot(1).getItem().getCount();
        if (change < 0) {
            if (this.currentMode == 0) {
                this.currentPriority = (short)Math.max(this.currentPriority + change, -4096);
            } else {
                this.currentFluidExtractAmt = Math.max(this.currentFluidExtractAmt + change, 1);
            }
        } else if (this.currentMode == 0) {
            this.currentPriority = (short)Math.min(this.currentPriority + change, 4096);
        } else {
            this.currentFluidExtractAmt = Math.min(this.currentFluidExtractAmt + change, Math.max(overClockerCount * (Integer)Config.MULTIPLIER_MILLI_BUCKETS_FLUID.get(), (Integer)Config.BASE_MILLI_BUCKETS_FLUID.get()));
        }
    }

    @Override
    public boolean filterSlot(int btn) {
        int newMBAmt;
        ItemStack slotStack = this.hoveredSlot.getItem();
        if (!FilterCount.doesItemStackHoldFluids(slotStack)) {
            return super.filterSlot(btn);
        }
        if (slotStack.isEmpty()) {
            return true;
        }
        if (btn == 2) {
            slotStack.setCount(0);
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GhostSlotPayload(this.hoveredSlot.index, slotStack, slotStack.getCount(), 0)});
            return true;
        }
        int amt = btn == 0 ? 1 : -1;
        int filterSlot = this.hoveredSlot.index - 2;
        int currentMBAmt = FilterCount.getSlotAmount(this.filter, filterSlot);
        if (Screen.hasShiftDown()) {
            amt *= 10;
        }
        if (Screen.hasControlDown()) {
            amt *= 100;
        }
        if ((newMBAmt = currentMBAmt + amt) < 0) {
            newMBAmt = 0;
        }
        if (newMBAmt > 4096000) {
            newMBAmt = 4096000;
        }
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GhostSlotPayload(this.hoveredSlot.index, slotStack, slotStack.getCount(), newMBAmt)});
        return true;
    }

    @Override
    public void setExtract(NumberButton amountButton, int btn) {
        if (btn == 0) {
            this.changeAmount(1);
        } else if (btn == 1) {
            this.changeAmount(-1);
        }
        amountButton.setValue(this.currentMode == 0 ? this.currentPriority : this.currentFluidExtractAmt);
        amountButton.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    @Override
    public void openNode() {
        this.saveSettings();
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.sourceContainer, this.container.direction)});
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        return super.mouseScrolled(mouseX, mouseY, delta, deltaY);
    }

    @Override
    public void saveSettings() {
        if (this.showFilter) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateFilterPayload(this.isAllowList == 1, this.isCompareNBT == 1)});
        }
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateCardPayload(this.currentMode, this.currentChannel, this.currentFluidExtractAmt, this.currentPriority, this.currentSneaky, (short)this.currentTicks, this.currentExact, this.currentRegulate, (byte)this.currentRoundRobin, 0, 0, this.currentRedstoneMode, this.currentRedstoneChannel, this.currentAndMode)});
    }
}

