/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.network.data.OpenNodePayload;
import com.direwolf20.laserio.common.network.data.UpdateRedstoneCardPayload;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class CardRedstoneScreen
extends AbstractContainerScreen<CardRedstoneContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/redstonecard.png");
    protected final CardRedstoneContainer container;
    protected byte currentMode;
    protected byte currentRedstoneChannel;
    protected boolean currentStrong;
    protected final ItemStack card;
    protected Map<String, Button> buttons = new HashMap<String, Button>();

    public CardRedstoneScreen(CardRedstoneContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Button channelButton;
        Button strongButton;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.getX(), modeButton.getY(), modeButton.getWidth(), modeButton.getHeight(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[3];
            translatableComponents[0] = Component.translatable((String)"screen.laserio.input");
            translatableComponents[1] = Component.translatable((String)"screen.laserio.output");
            guiGraphics.renderTooltip(this.font, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (this.currentMode == 1 && MiscTools.inBounds((strongButton = this.buttons.get("strong")).getX(), strongButton.getY(), strongButton.getWidth(), strongButton.getHeight(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.translatable((String)"screen.laserio.weak"), Component.translatable((String)"screen.laserio.strong")};
            guiGraphics.renderTooltip(this.font, (Component)translatableComponents[this.currentStrong ? 1 : 0], mouseX, mouseY);
        }
        if (MiscTools.inBounds((channelButton = this.buttons.get("channel")).getX(), channelButton.getY(), channelButton.getWidth(), channelButton.getHeight(), mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.redstonechannel").append(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneinput.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneoutput.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = CardRedstone.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            this.modeChange();
        }));
    }

    public void addStrongButton() {
        ResourceLocation[] strongTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("strong", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, strongTextures, this.currentStrong ? 1 : 0, button -> {
            this.currentStrong = !this.currentStrong;
            ((ToggleButton)button).setTexturePosition(this.currentStrong ? 1 : 0);
        }));
    }

    public void addChannelButton() {
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void init() {
        super.init();
        this.currentMode = CardRedstone.getTransferMode(this.card);
        this.currentRedstoneChannel = CardRedstone.getRedstoneChannel(this.card);
        this.currentStrong = CardRedstone.getStrong(this.card);
        this.addModeButton();
        this.addChannelButton();
        this.addStrongButton();
        if (this.container.direction != -1) {
            this.buttons.put("return", (Button)new ExtendedButton(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.literal((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.addRenderableWidget((GuiEventListener)button2.getValue());
        }
        this.modeChange();
    }

    public void modeChange() {
        Button strongButton = this.buttons.get("strong");
        if (this.currentMode == 0) {
            this.removeWidget((GuiEventListener)strongButton);
        } else if (this.currentMode == 1 && !this.renderables.contains(strongButton)) {
            this.addRenderableWidget((GuiEventListener)strongButton);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.saveSettings();
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        return super.mouseScrolled(mouseX, mouseY, delta, deltaY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("laserio." + key), (Object[])args);
    }

    public void saveSettings() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateRedstoneCardPayload(this.currentMode, this.currentRedstoneChannel, this.currentStrong)});
    }

    public void openNode() {
        this.saveSettings();
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.sourceContainer, this.container.direction)});
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean mouseClicked(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.getX(), channelButton.getY(), channelButton.getWidth(), channelButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = CardRedstone.previousRedstoneChannel(this.card);
            }
            channelButton.setChannel(this.currentRedstoneChannel);
            channelButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return super.mouseClicked(x, y, btn);
    }
}

