/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.FilterBasicContainer;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.network.data.GhostSlotPayload;
import com.direwolf20.laserio.common.network.data.UpdateFilterPayload;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterBasicScreen
extends AbstractContainerScreen<FilterBasicContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/basicfilter.png");
    protected final FilterBasicContainer container;
    private ItemStack filter;
    private boolean isAllowList;
    private boolean isCompareNBT;

    public FilterBasicScreen(FilterBasicContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.filter = container.filterItem;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.getGuiLeft() + 5, this.getGuiTop() + 10, 16, 16, mouseX, mouseY)) {
            if (this.isAllowList) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.allowlist"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.denylist"), mouseX, mouseY);
            }
        }
        if (!(this.filter.getItem() instanceof FilterMod) && MiscTools.inBounds(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, mouseX, mouseY)) {
            if (this.isCompareNBT) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.nbttrue"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.nbtfalse"), mouseX, mouseY);
            }
        }
    }

    public void init() {
        super.init();
        ArrayList<ToggleButton> leftWidgets = new ArrayList<ToggleButton>();
        this.isAllowList = FilterBasic.getAllowList(this.filter);
        this.isCompareNBT = FilterBasic.getCompareNBT(this.filter);
        ResourceLocation[] allowListTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/allowlistfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/allowlisttrue.png")};
        leftWidgets.add(new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, allowListTextures, this.isAllowList ? 1 : 0, button -> {
            this.isAllowList = !this.isAllowList;
            ((ToggleButton)button).setTexturePosition(this.isAllowList ? 1 : 0);
        }));
        if (!(this.filter.getItem() instanceof FilterMod)) {
            ResourceLocation[] nbtTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/matchnbtfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/matchnbttrue.png")};
            leftWidgets.add(new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, nbtTextures, this.isCompareNBT ? 1 : 0, button -> {
                this.isCompareNBT = !this.isCompareNBT;
                ((ToggleButton)button).setTexturePosition(this.isCompareNBT ? 1 : 0);
            }));
        }
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.addRenderableWidget((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateFilterPayload(this.isAllowList, this.isCompareNBT)});
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        if (this.hoveredSlot == null || !(this.hoveredSlot instanceof FilterBasicSlot)) {
            return super.mouseClicked(x, y, btn);
        }
        ItemStack stack = ((FilterBasicContainer)this.menu).getCarried();
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)(stack = stack.copy().split(this.hoveredSlot.getMaxStackSize())), (ItemStack)this.container.filterItem)) {
            return true;
        }
        this.hoveredSlot.set(stack);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GhostSlotPayload(this.hoveredSlot.index, stack, stack.getCount(), -1)});
        return true;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double pScrollX, double pScrollY) {
        return super.mouseScrolled(mouseX, mouseY, pScrollX, pScrollY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("laserio." + key), (Object[])args);
    }
}

