/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ItemDecoratorHandler;
import org.jetbrains.annotations.Nullable;

public class LaserGuiGraphics
extends GuiGraphics {
    public Minecraft minecraft;

    public LaserGuiGraphics(Minecraft minecraft, MultiBufferSource.BufferSource bufferSource) {
        super(minecraft, bufferSource);
        this.minecraft = minecraft;
    }

    public void renderItemDecorations(Font font, ItemStack itemStack, int x, int y, @Nullable String altText) {
        PoseStack pose = this.pose();
        if (!itemStack.isEmpty()) {
            LocalPlayer localplayer;
            float f;
            pose.pushPose();
            if (itemStack.getCount() != 1 || altText != null) {
                String s = altText == null ? String.valueOf(itemStack.getCount()) : altText;
                this.pose().translate(0.0f, 0.0f, 200.0f);
                if (itemStack.getCount() > 99) {
                    pose.pushPose();
                    pose.translate((float)x, (float)y, 300.0f);
                    pose.scale(0.65f, 0.65f, 0.65f);
                    this.drawString(font, s, 17.0f - (float)font.width(s) * 0.65f, 17.0f, 0xFFFFFF, true);
                    pose.popPose();
                } else {
                    this.drawString(font, s, x + 19 - 2 - font.width(s), y + 6 + 3, 0xFFFFFF, true);
                }
            }
            if (itemStack.isBarVisible()) {
                int l = itemStack.getBarWidth();
                int i = itemStack.getBarColor();
                int j = x + 2;
                int k = y + 13;
                this.fill(RenderType.guiOverlay(), j, k, j + 13, k + 2, -16777216);
                this.fill(RenderType.guiOverlay(), j, k, j + l, k + 1, i | 0xFF000000);
            }
            float f2 = f = (localplayer = this.minecraft.player) == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(itemStack.getItem(), this.minecraft.getFrameTime());
            if (f > 0.0f) {
                int i1 = y + Mth.floor((float)(16.0f * (1.0f - f)));
                int j1 = i1 + Mth.ceil((float)(16.0f * f));
                this.fill(RenderType.guiOverlay(), x, i1, x + 16, j1, Integer.MAX_VALUE);
            }
            pose.popPose();
            ItemDecoratorHandler.of((ItemStack)itemStack).render((GuiGraphics)this, font, itemStack, x, y);
        }
    }

    public void renderItemScale(float scale, ItemStack itemStack, int x, int y) {
        boolean flag;
        PoseStack posestack = this.pose();
        posestack.pushPose();
        posestack.translate((float)x, (float)y, 500.0f);
        posestack.translate(8.0, 8.0, 0.0);
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(scale, scale, scale);
        BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getModel(itemStack, null, null, 0);
        boolean bl = flag = !bakedmodel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        this.minecraft.getItemRenderer().render(itemStack, ItemDisplayContext.GUI, false, this.pose(), (MultiBufferSource)this.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
        this.flush();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popPose();
    }
}

