/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.CardChemicalScreen;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LaserGuiGraphicsChemical
extends GuiGraphics {
    public Minecraft minecraft;
    protected final AbstractContainerScreen<?> screen;

    public LaserGuiGraphicsChemical(Minecraft minecraft, MultiBufferSource.BufferSource bufferSource, AbstractContainerScreen<?> screen) {
        super(minecraft, bufferSource);
        this.minecraft = minecraft;
        this.screen = screen;
    }

    public void renderItemDecorations(Font font, ItemStack itemstack, int x, int y, @Nullable String altText) {
        if (this.shouldRenderChemical(itemstack, x, y, true, false)) {
            CardChemicalScreen cardChemicalScreen = (CardChemicalScreen)this.screen;
            int sloty = Mth.floor((double)((double)(y - cardChemicalScreen.filterStartY) / 18.0));
            int slotx = Mth.floor((double)((double)(x - cardChemicalScreen.filterStartX) / 18.0));
            int slot = 5 * sloty + slotx;
            ItemStack filter = ((CardChemicalScreen)this.screen).filter;
            int totalmbAmt = FilterCount.getSlotAmount(filter, slot);
            int count = Mth.floor((double)((double)totalmbAmt / 1000.0));
            int mbAmt = totalmbAmt % 1000;
            PoseStack posestack = this.pose();
            if (count != 0 || mbAmt != 0) {
                String textToDraw = count + "b";
                posestack.pushPose();
                posestack.translate((float)x, (float)y, 200.0f);
                posestack.scale(0.5f, 0.5f, 0.5f);
                if (mbAmt == 0) {
                    this.drawString(font, textToDraw, 17.0f - (float)font.width(textToDraw) * 0.5f, 24.0f, 0xFFFFFF, true);
                } else {
                    String textToDraw2 = mbAmt + "mb";
                    this.drawString(font, textToDraw, 17.0f - (float)font.width(textToDraw) * 0.5f, 14.0f, 0xFFFFFF, true);
                    this.drawString(font, textToDraw2, 17.0f - (float)font.width(textToDraw2) * 0.5f, 24.0f, 0xFFFFFF, true);
                }
                posestack.popPose();
            }
        } else if (!itemstack.isEmpty()) {
            LocalPlayer localplayer;
            float f;
            PoseStack posestack = this.pose();
            if (itemstack.getCount() != 1 || altText != null) {
                String textToDraw = altText == null ? String.valueOf(itemstack.getCount()) : altText;
                posestack.translate(0.0, 0.0, 200.0);
                if (itemstack.getCount() > 99) {
                    posestack.pushPose();
                    posestack.translate((float)x, (float)y, 300.0f);
                    posestack.scale(0.65f, 0.65f, 0.65f);
                    this.drawString(font, textToDraw, 17.0f - (float)font.width(textToDraw) * 0.65f, 17.0f, 0xFFFFFF, true);
                    posestack.popPose();
                } else {
                    this.drawString(font, textToDraw, x + 19 - 2 - font.width(textToDraw), y + 6 + 3, 0xFFFFFF, true);
                }
            }
            if (!this.shouldRenderChemical(itemstack, x, y, true, true)) {
                this.fill(RenderType.guiOverlay(), x, y, x + 16, y + Mth.ceil((float)16.0f), 0x7FFF0000);
            }
            if (itemstack.isBarVisible()) {
                int i = itemstack.getBarWidth();
                int j = itemstack.getBarColor();
                this.fill(RenderType.guiOverlay(), x + 2, y + 13, x + 15, y + 15, -16777216);
                this.fill(RenderType.guiOverlay(), x + 2, y + 13, x + 2 + i, y + 14, j | 0xFF000000);
            }
            float f2 = f = (localplayer = Minecraft.getInstance().player) == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(itemstack.getItem(), Minecraft.getInstance().getFrameTime());
            if (f > 0.0f) {
                int yMin = y + Mth.floor((float)(16.0f * (1.0f - f)));
                int yMax = yMin + Mth.ceil((float)(16.0f * f));
                this.fill(RenderType.guiOverlay(), x, yMin, x + 16, yMax, Integer.MAX_VALUE);
            }
        }
    }

    private boolean shouldRenderChemical(ItemStack pStack, int pX, int pY, boolean includeCarried, boolean reverseBounds) {
        AbstractContainerScreen<?> abstractContainerScreen = this.screen;
        if (!(abstractContainerScreen instanceof CardChemicalScreen)) {
            return reverseBounds;
        }
        CardChemicalScreen cardChemicalScreen = (CardChemicalScreen)abstractContainerScreen;
        if (includeCarried && ((CardItemContainer)cardChemicalScreen.getMenu()).getCarried().equals(pStack)) {
            return reverseBounds;
        }
        if (reverseBounds) {
            return !MiscTools.inBounds(cardChemicalScreen.filterStartX, cardChemicalScreen.filterStartY, cardChemicalScreen.filterEndX - cardChemicalScreen.filterStartX, cardChemicalScreen.filterEndY - cardChemicalScreen.filterStartY, pX, pY);
        }
        if (!MiscTools.inBounds(cardChemicalScreen.filterStartX, cardChemicalScreen.filterStartY, cardChemicalScreen.filterEndX - cardChemicalScreen.filterStartX, cardChemicalScreen.filterEndY - cardChemicalScreen.filterStartY, pX, pY)) {
            return false;
        }
        ChemicalStack<?> chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(pStack);
        return !chemicalStack.isEmpty() && Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(chemicalStack.getType().getIcon()) != null;
    }

    public void renderItem(ItemStack pStack, int pX, int pY, int something) {
        if (!this.shouldRenderChemical(pStack, pX, pY, true, false)) {
            super.renderItem(pStack, pX, pY, something);
            return;
        }
        ChemicalStack<?> chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(pStack);
        TextureAtlasSprite chemicalSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(chemicalStack.getType().getIcon());
        int chemicalColor = chemicalStack.getChemicalColorRepresentation();
        float red = (float)(chemicalColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(chemicalColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(chemicalColor & 0xFF) / 255.0f;
        this.blit(pX, pY, 100, 16, 16, chemicalSprite, red, green, blue, 1.0f);
    }
}

