/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.network.data.ChangeColorPayload;
import com.direwolf20.laserio.common.network.data.OpenNodePayload;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.Vec2i;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;

public class LaserNodeSettingsScreen
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/laser_node_settings.png");
    protected final LaserNodeContainer container;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private int laserRed;
    private int laserGreen;
    private int laserBlue;
    private int laserAlpha;
    private int wrenchAlpha;
    private ExtendedSlider sliderRed;
    private ExtendedSlider sliderGreen;
    private ExtendedSlider sliderBlue;
    private ExtendedSlider sliderAlpha;
    private ExtendedSlider sliderWrenchAlpha;
    private final MutableComponent[] sides = new MutableComponent[]{Component.translatable((String)"screen.laserio.down"), Component.translatable((String)"screen.laserio.up"), Component.translatable((String)"screen.laserio.north"), Component.translatable((String)"screen.laserio.south"), Component.translatable((String)"screen.laserio.west"), Component.translatable((String)"screen.laserio.east")};
    private Map<ExtendedSlider, IntConsumer> sliderMap = new HashMap<ExtendedSlider, IntConsumer>();
    private final Vec2i[] tabs = new Vec2i[]{new Vec2i(34, 4), new Vec2i(6, 4), new Vec2i(62, 4), new Vec2i(90, 4), new Vec2i(118, 4), new Vec2i(146, 4)};

    public LaserNodeSettingsScreen(LaserNodeContainer container, Component name) {
        super(name);
        this.container = container;
        this.imageHeight = 181;
        Color color = container.tile.getColor();
        this.laserRed = color.getRed();
        this.laserGreen = color.getGreen();
        this.laserBlue = color.getBlue();
        this.laserAlpha = color.getAlpha();
        this.wrenchAlpha = container.tile.getWrenchAlpha();
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        if (this.container.side != -1) {
            ExtendedButton returnButton = new ExtendedButton(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.literal((String)"<--"), button -> {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.tile.getBlockPos(), this.container.side)});
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            });
            leftWidgets.add(returnButton);
        }
        ExtendedButton applyButton = new ExtendedButton(this.getGuiLeft() + 25, this.getGuiTop() + 150, 50, 20, (Component)Component.translatable((String)"screen.laserio.apply"), button -> this.syncColors());
        leftWidgets.add(applyButton);
        ExtendedButton defaultButton = new ExtendedButton(this.getGuiLeft() + 100, this.getGuiTop() + 150, 50, 20, (Component)Component.translatable((String)"screen.laserio.default"), button -> {
            Color defaultColor = this.container.tile.getDefaultColor();
            this.laserRed = defaultColor.getRed();
            this.sliderRed.setValue((double)this.laserRed);
            this.laserGreen = defaultColor.getGreen();
            this.sliderGreen.setValue((double)this.laserGreen);
            this.laserBlue = defaultColor.getBlue();
            this.sliderBlue.setValue((double)this.laserBlue);
            this.laserAlpha = defaultColor.getAlpha();
            this.sliderAlpha.setValue((double)this.laserAlpha);
            this.wrenchAlpha = 0;
            this.sliderWrenchAlpha.setValue(0.0);
            this.syncColors();
        });
        leftWidgets.add(defaultButton);
        this.sliderRed = new ExtendedSlider(this.getGuiLeft() + 15, this.getGuiTop() + 45, 150, 15, (Component)Component.translatable((String)"screen.laserio.red").append(": "), (Component)Component.empty(), 0.0, 255.0, this.laserRed, true){

            protected void applyValue() {
                LaserNodeSettingsScreen.this.laserRed = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderRed);
        this.sliderGreen = new ExtendedSlider(this.getGuiLeft() + 15, this.getGuiTop() + 65, 150, 15, (Component)Component.translatable((String)"screen.laserio.green").append(": "), (Component)Component.empty(), 0.0, 255.0, this.laserGreen, true){

            protected void applyValue() {
                LaserNodeSettingsScreen.this.laserGreen = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderGreen);
        this.sliderBlue = new ExtendedSlider(this.getGuiLeft() + 15, this.getGuiTop() + 85, 150, 15, (Component)Component.translatable((String)"screen.laserio.blue").append(": "), (Component)Component.empty(), 0.0, 255.0, this.laserBlue, true){

            protected void applyValue() {
                LaserNodeSettingsScreen.this.laserBlue = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderBlue);
        this.sliderAlpha = new ExtendedSlider(this.getGuiLeft() + 15, this.getGuiTop() + 105, 150, 15, (Component)Component.translatable((String)"screen.laserio.alpha").append(": "), (Component)Component.empty(), 0.0, 255.0, this.laserAlpha, true){

            protected void applyValue() {
                LaserNodeSettingsScreen.this.laserAlpha = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderAlpha);
        this.sliderWrenchAlpha = new ExtendedSlider(this.getGuiLeft() + 15, this.getGuiTop() + 125, 150, 15, (Component)Component.translatable((String)"screen.laserio.wrench").append(": "), (Component)Component.empty(), 0.0, 255.0, this.wrenchAlpha, true){

            protected void applyValue() {
                LaserNodeSettingsScreen.this.wrenchAlpha = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderWrenchAlpha);
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.addRenderableWidget((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
        this.sliderMap = Map.of(this.sliderRed, a -> {
            this.laserRed = a;
        }, this.sliderGreen, a -> {
            this.laserGreen = a;
        }, this.sliderBlue, a -> {
            this.laserBlue = a;
        }, this.sliderAlpha, a -> {
            this.laserAlpha = a;
        }, this.sliderWrenchAlpha, a -> {
            this.wrenchAlpha = a;
        });
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderLabels(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        this.sliderMap.forEach((slider, consumer) -> {
            if (slider.isMouseOver(mouseX, mouseY)) {
                slider.setValue((double)(slider.getValueInt() + (delta > 0.0 ? 1 : -1)));
                consumer.accept(slider.getValueInt());
            }
        });
        return false;
    }

    private void syncColors() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ChangeColorPayload(this.container.tile.getBlockPos(), new Color(this.laserRed, this.laserGreen, this.laserBlue, this.laserAlpha).getRGB(), this.wrenchAlpha)});
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
        guiGraphics.fill(this.tabs[this.container.side].x + 2, this.tabs[this.container.side].y + 2, this.tabs[this.container.side].x + 22, this.tabs[this.container.side].y + 14, -3750202);
        guiGraphics.fill(this.tabs[this.container.side].x, this.tabs[this.container.side].y + 11, this.tabs[this.container.side].x + 2, this.tabs[this.container.side].y + 12, -1);
        guiGraphics.fill(this.tabs[this.container.side].x + 22, this.tabs[this.container.side].y + 11, this.tabs[this.container.side].x + 24, this.tabs[this.container.side].y + 12, -1);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"screen.laserio.settings"), this.imageWidth / 2 - this.font.width((FormattedText)Component.translatable((String)"screen.laserio.settings")) / 2, 20, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "U", 15, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "D", 43, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "N", 71, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "S", 99, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "W", 128, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "E", 155, 7, Color.DARK_GRAY.getRGB(), false);
        for (Direction direction : Direction.values()) {
            ItemStack itemStack = this.getAdjacentBlock(direction);
            if (itemStack.isEmpty()) continue;
            guiGraphics.renderItem(itemStack, this.tabs[direction.ordinal()].x + 4, this.tabs[direction.ordinal()].y - 14, 0);
            if (!MiscTools.inBounds(this.getGuiLeft() + this.tabs[direction.ordinal()].x + 4, this.getGuiTop() + this.tabs[direction.ordinal()].y - 14, 16, 16, mouseX, mouseY)) continue;
            guiGraphics.renderTooltip(this.font, itemStack, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        int startX = 15;
        int startY = 30;
        guiGraphics.fill(startX, startY, startX + 150, startY + 10, new Color(this.laserRed, this.laserGreen, this.laserBlue, this.laserAlpha).getRGB());
        guiGraphics.pose().popPose();
    }

    protected ItemStack getAdjacentBlock(Direction direction) {
        BlockState blockState = this.container.playerEntity.level().getBlockState(this.container.tile.getBlockPos().relative(direction));
        ItemStack itemStack = blockState.getBlock().asItem().getDefaultInstance();
        return itemStack;
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[1].x, this.getGuiTop() + this.tabs[1].y, 24, 12, x, y)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.tile.getBlockPos(), 1)});
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[0].x, this.getGuiTop() + this.tabs[0].y, 24, 12, x, y)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.tile.getBlockPos(), 0)});
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[2].x, this.getGuiTop() + this.tabs[2].y, 24, 12, x, y)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.tile.getBlockPos(), 2)});
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[3].x, this.getGuiTop() + this.tabs[3].y, 24, 12, x, y)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.tile.getBlockPos(), 3)});
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[4].x, this.getGuiTop() + this.tabs[4].y, 24, 12, x, y)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.tile.getBlockPos(), 4)});
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[5].x, this.getGuiTop() + this.tabs[5].y, 24, 12, x, y)) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenNodePayload(this.container.tile.getBlockPos(), 5)});
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return super.mouseClicked(x, y, btn);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public int getGuiLeft() {
        return this.leftPos;
    }

    public int getGuiTop() {
        return this.topPos;
    }
}

