/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blockentities;

import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.DimBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LaserConnectorAdvBE
extends BaseLaserBE {
    protected DimBlockPos partnerDimBlockPos;

    public LaserConnectorAdvBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.LaserConnectorAdv_BE.get(), pos, state);
    }

    public DimBlockPos getPartnerDimBlockPos() {
        return this.partnerDimBlockPos;
    }

    public void setPartnerDimBlockPos(DimBlockPos partnerDimBlockPos) {
        this.partnerDimBlockPos = partnerDimBlockPos;
        this.markDirtyClient();
    }

    public boolean isPartnerNodeConnected(DimBlockPos pos) {
        return this.partnerDimBlockPos != null && this.partnerDimBlockPos.equals(pos);
    }

    public void handleAdvancedConnection(LaserConnectorAdvBE be) {
        DimBlockPos connectingDimPos = new DimBlockPos(be.getLevel(), be.getBlockPos());
        if (this.isPartnerNodeConnected(connectingDimPos)) {
            this.removePartnerConnection();
        } else {
            this.addPartnerConnection(connectingDimPos, be);
        }
    }

    public void addPartnerConnection(DimBlockPos connectingDimPos, LaserConnectorAdvBE be) {
        if (this.getPartnerDimBlockPos() != null) {
            this.removePartnerConnection();
        }
        if (be.getPartnerDimBlockPos() != null) {
            be.removePartnerConnection();
        }
        this.setPartnerDimBlockPos(connectingDimPos);
        be.setPartnerDimBlockPos(new DimBlockPos(this.getLevel(), this.getBlockPos()));
        if (this.getColor().equals(this.getDefaultColor()) && !be.getColor().equals(be.getDefaultColor())) {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        } else if (be.getColor().equals(be.getDefaultColor()) && !this.getColor().equals(this.getDefaultColor())) {
            be.setColor(this.getColor(), this.getWrenchAlpha());
        } else {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        }
        this.discoverAllNodes();
    }

    public void removePartnerConnection() {
        DimBlockPos partnerDimPos;
        BlockEntity partnerBE;
        if (this.getPartnerDimBlockPos() != null && (partnerBE = (partnerDimPos = this.getPartnerDimBlockPos()).getLevel(this.level.getServer()).getBlockEntity(partnerDimPos.blockPos)) instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE be = (LaserConnectorAdvBE)partnerBE;
            be.setPartnerDimBlockPos(null);
            be.discoverAllNodes();
        }
        this.setPartnerDimBlockPos(null);
        this.discoverAllNodes();
    }

    @Override
    public void disconnectAllNodes() {
        this.removePartnerConnection();
        super.disconnectAllNodes();
    }

    @Override
    public void validateConnections(BlockPos originalPos) {
        DimBlockPos partner = this.getPartnerDimBlockPos();
        if (partner == null) {
            this.removePartnerConnection();
            super.validateConnections(originalPos);
            return;
        }
        BlockEntity be = partner.getLevel(this.getLevel().getServer()).getBlockEntity(partner.blockPos);
        if (be instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE laserConnectorAdvBE = (LaserConnectorAdvBE)be;
            this.addPartnerConnection(partner, laserConnectorAdvBE);
        } else {
            this.removePartnerConnection();
        }
        super.validateConnections(originalPos);
    }

    @Override
    public void load(CompoundTag tag) {
        if (tag.contains("partnerDimPos")) {
            this.setPartnerDimBlockPos(new DimBlockPos(tag.getCompound("partnerDimPos")));
        } else {
            this.setPartnerDimBlockPos(null);
        }
        super.load(tag);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.getPartnerDimBlockPos() != null) {
            tag.put("partnerDimPos", (Tag)this.getPartnerDimBlockPos().toNBT());
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    @Override
    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.load(pkt.getTag());
    }
}

