/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers;

import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CardHolderContainer
extends AbstractContainerMenu {
    public static final int SLOTS = 15;
    public ItemStack cardHolder;
    public Player playerEntity;
    private IItemHandler playerInventory;
    public BlockPos sourceContainer = BlockPos.ZERO;
    public IItemHandler iItemHandler;

    public CardHolderContainer(int windowId, Inventory playerInventory, Player player, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, player, extraData.readItem(), (IItemHandler)new ItemStackHandler(15));
    }

    public CardHolderContainer(int windowId, Inventory playerInventory, Player player, ItemStack cardHolder, IItemHandler iItemHandler) {
        super((MenuType)Registration.CardHolder_Container.get(), windowId);
        this.playerEntity = player;
        this.iItemHandler = iItemHandler;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.cardHolder = cardHolder;
        if (iItemHandler != null) {
            this.addSlotBox(iItemHandler, 0, 44, 17, 5, 18, 3, 18);
        }
        this.layoutPlayerInventorySlots(8, 84);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && slotId < 15 && this.slots.get(slotId) instanceof CardHolderSlot) {
            ItemStack carriedItem = this.getCarried();
            ItemStack stackInSlot = ((Slot)this.slots.get(slotId)).getItem();
            if (!(stackInSlot.getMaxStackSize() != 1 || stackInSlot.getCount() <= 1 || carriedItem.isEmpty() || stackInSlot.isEmpty() || ItemStack.isSameItemSameTags((ItemStack)carriedItem, (ItemStack)stackInSlot))) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public boolean stillValid(Player playerIn) {
        return playerIn.getMainHandItem().equals(this.cardHolder) || playerIn.getOffhandItem().equals(this.cardHolder);
    }

    protected boolean moveItemStackTo(ItemStack itemStack, int fromSlot, int toSlot, boolean p_38907_) {
        boolean flag = false;
        int i = fromSlot;
        if (p_38907_) {
            i = toSlot - 1;
        }
        while (!itemStack.isEmpty() && !(!p_38907_ ? i >= toSlot : i < fromSlot)) {
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)itemstack)) {
                int maxSize;
                int j = itemstack.getCount() + itemStack.getCount();
                if (j <= (maxSize = Math.min(slot.getMaxStackSize(), slot.getMaxStackSize(itemStack)))) {
                    itemStack.setCount(0);
                    itemstack.setCount(j);
                    slot.setChanged();
                    flag = true;
                } else if (itemstack.getCount() < maxSize) {
                    itemStack.shrink(maxSize - itemstack.getCount());
                    itemstack.setCount(maxSize);
                    slot.setChanged();
                    flag = true;
                }
            }
            if (p_38907_) {
                --i;
                continue;
            }
            ++i;
        }
        if (!itemStack.isEmpty()) {
            i = p_38907_ ? toSlot - 1 : fromSlot;
            while (!(!p_38907_ ? i >= toSlot : i < fromSlot)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(itemStack) && slot1.getItem().getCount() < slot1.getMaxStackSize(itemStack)) {
                    if (itemStack.getCount() > slot1.getMaxStackSize()) {
                        slot1.set(itemStack.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.set(itemStack.split(slot1.getMaxStackSize(itemStack)));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return !(slot instanceof CardHolderSlot);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index < 15) {
                if (playerIn.getInventory().getFreeSlot() != -1) {
                    if (stack.getMaxStackSize() == 1) {
                        this.moveItemStackTo(stack.split(1), 15, 51, true);
                    } else {
                        this.moveItemStackTo(stack, 15, 51, true);
                    }
                } else {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemstack);
            } else if (!this.moveItemStackTo(stack, 0, 15, false)) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack);
            if (stack.getCount() < itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler.getSlots() == 15) {
                this.addSlot((Slot)new CardHolderSlot(handler, index, x, y));
            } else {
                this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
    }
}

