/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class FilterCountContainer
extends AbstractContainerMenu {
    public static final int SLOTS = 15;
    public FilterCountHandler handler;
    public ItemStack filterItem;
    public Player playerEntity;
    public ItemStack sourceCard = ItemStack.EMPTY;
    private IItemHandler playerInventory;
    public BlockPos sourceContainer = BlockPos.ZERO;

    public FilterCountContainer(int windowId, Inventory playerInventory, Player player, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, player, extraData.readItem());
        this.sourceCard = extraData.readItem();
    }

    public FilterCountContainer(int windowId, Inventory playerInventory, Player player, ItemStack filterItem) {
        super((MenuType)Registration.FilterCount_Container.get(), windowId);
        this.playerEntity = player;
        this.handler = FilterCount.getInventory(filterItem);
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.filterItem = filterItem;
        if (this.handler != null) {
            this.addSlotBox((IItemHandler)this.handler, 0, 44, 22, 5, 18, 3, 18);
        }
        this.layoutPlayerInventorySlots(8, 84);
    }

    public FilterCountContainer(int windowId, Inventory playerInventory, Player player, BlockPos sourcePos, ItemStack filterItem, ItemStack sourceCard) {
        this(windowId, playerInventory, player, filterItem);
        this.sourceContainer = sourcePos;
        this.sourceCard = sourceCard;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && slotId < 15) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public int getStackSize(int slot) {
        ItemStack filterStack = this.handler.stack;
        if (slot >= 0 && slot < 15 && this.slots.get(slot) instanceof FilterBasicSlot) {
            return FilterCount.getSlotCount(filterStack, slot);
        }
        return 0;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack currentStack = slot.getItem().copy();
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)currentStack, (ItemStack)this.filterItem)) {
                return ItemStack.EMPTY;
            }
            if (index >= 15) {
                for (int i = 0; i < 15; ++i) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((Slot)this.slots.get(i)).getItem(), (ItemStack)currentStack)) continue;
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(currentStack, 0, 15, false)) {
                    return ItemStack.EMPTY;
                }
                this.handler.syncSlots();
            }
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler instanceof FilterCountHandler) {
                this.addSlot((Slot)new FilterBasicSlot(handler, index, x, y, true));
            } else {
                this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public void removed(Player playerIn) {
        Level world = playerIn.level();
        if (!world.isClientSide) {
            BlockEntity blockEntity;
            if (!this.sourceCard.isEmpty()) {
                ItemStack overclockerStack = BaseCard.getInventory(this.sourceCard).getStackInSlot(1);
                CardItemHandler cardHandler = new CardItemHandler(2, this.sourceCard);
                cardHandler.setStackInSlot(0, this.filterItem);
                cardHandler.setStackInSlot(1, overclockerStack);
                BaseCard.setInventory(this.sourceCard, cardHandler);
            }
            if (!this.sourceContainer.equals((Object)BlockPos.ZERO) && (blockEntity = world.getBlockEntity(this.sourceContainer)) instanceof LaserNodeBE) {
                ((LaserNodeBE)blockEntity).updateThisNode();
            }
        }
        super.removed(playerIn);
    }
}

