/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class FilterNBTContainer
extends AbstractContainerMenu {
    public static final int SLOTS = 1;
    public FilterBasicHandler handler;
    public ItemStack filterItem;
    public ItemStack sourceCard = ItemStack.EMPTY;
    public Player playerEntity;
    private IItemHandler playerInventory;
    public BlockPos sourceContainer = BlockPos.ZERO;

    public FilterNBTContainer(int windowId, Inventory playerInventory, Player player, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, player, new FilterBasicHandler(1, ItemStack.EMPTY), ItemStack.EMPTY);
        this.filterItem = extraData.readItem();
        this.sourceCard = extraData.readItem();
    }

    public FilterNBTContainer(int windowId, Inventory playerInventory, Player player, FilterBasicHandler handler, ItemStack filterItem) {
        super((MenuType)Registration.FilterNBT_Container.get(), windowId);
        this.playerEntity = player;
        this.handler = handler;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.filterItem = filterItem;
        if (handler != null) {
            this.addSlotRange((IItemHandler)handler, 0, 177, 6, 1, 18);
        }
        this.layoutPlayerInventorySlots(8, 172);
    }

    public FilterNBTContainer(int windowId, Inventory playerInventory, Player player, FilterBasicHandler handler, BlockPos sourcePos, ItemStack filterItem, ItemStack sourceCard) {
        this(windowId, playerInventory, player, handler, filterItem);
        this.sourceContainer = sourcePos;
        this.sourceCard = sourceCard;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && slotId < 1) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack currentStack = slot.getItem().copy();
            currentStack.setCount(1);
            if (index >= 1) {
                for (int i = 0; i < 1; ++i) {
                    this.handler.setStackInSlot(i, ItemStack.EMPTY);
                }
                if (!this.moveItemStackTo(currentStack, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            }
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler instanceof FilterBasicHandler) {
                this.addSlot((Slot)new FilterBasicSlot(handler, index, x, y, false));
            } else {
                this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public void removed(Player playerIn) {
        Level world = playerIn.level();
        if (!world.isClientSide) {
            BlockEntity blockEntity;
            this.handler.setStackInSlot(0, ItemStack.EMPTY);
            if (!this.sourceCard.isEmpty()) {
                ItemStack overclockerStack = BaseCard.getInventory(this.sourceCard).getStackInSlot(1);
                CardItemHandler cardHandler = new CardItemHandler(2, this.sourceCard);
                cardHandler.setStackInSlot(0, this.filterItem);
                cardHandler.setStackInSlot(1, overclockerStack);
                BaseCard.setInventory(this.sourceCard, cardHandler);
            }
            if (!this.sourceContainer.equals((Object)BlockPos.ZERO) && (blockEntity = world.getBlockEntity(this.sourceContainer)) instanceof LaserNodeBE) {
                ((LaserNodeBE)blockEntity).updateThisNode();
            }
        }
        super.removed(playerIn);
    }
}

